package com.bxm.localnews.im.domain.group;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.localnews.im.entity.group.ImGroupAreaEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author lowi
 * @since 2021-12-21
 */
@Mapper
public interface ImGroupAreaMapper extends BaseMapper<ImGroupAreaEntity> {

    /**
     * 获取当前地区的群组数量
     *
     * @param areaCode 地区
     * @return 数量
     */
    Integer getAreaGroupSize(String areaCode);

    /**
     * 清除掉群聊地区信息
     *
     * @param groupId 分组id
     * @return 成功结果
     */
    Integer clearGroupArea(Long groupId);

    /**
     * 批量插入分组地区信息
     *
     * @param imGroupAreaEntities 原始信息
     * @return 是否成功
     */
    int batchInsertGroupArea(@Param("list") List<ImGroupAreaEntity> imGroupAreaEntities);

    /**
     * 获取地区根据群组id
     *
     * @param groupId 群聊id
     * @return 地区列表
     */
    List<String> getAreaByGroupId(Long groupId);
}
