package com.bxm.localnews.im.domain.group;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.localnews.im.bo.GroupInfoBO;
import com.bxm.localnews.im.dto.group.GroupManageListItemDTO;
import com.bxm.localnews.im.dto.group.GroupRuntimeInfoDTO;
import com.bxm.localnews.im.entity.group.ImGroupEntity;
import com.bxm.localnews.im.param.group.GroupListParam;
import com.bxm.localnews.im.param.group.GroupManageQueryParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 群组基础信息 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-17
 */
@Mapper
public interface ImGroupMapper extends BaseMapper<ImGroupEntity> {

    /**
     * 分页查询群组信息
     *
     * @param page  分页参数
     * @param param 查询参数
     * @return 分页结果
     */
    IPage<GroupManageListItemDTO> queryByPage(@Param("page") Page<GroupManageListItemDTO> page,
                                              @Param("param") GroupManageQueryParam param);

    /**
     * 获取指定地区可用的群聊，包括已满员的群组
     * 用户不在黑名单中
     *
     * @param areaCode 地区编码
     * @param userId   用户ID
     * @return 群聊信息
     */
    List<GroupInfoBO> getEnableGroupByArea(@Param("areaCode") String areaCode, @Param("userId") Long userId);

    /**
     * 查询群组实时信息
     *
     * @param groupId 群组ID
     * @return 实时信息
     */
    GroupRuntimeInfoDTO queryRuntimeInfo(Long groupId);

    /**
     * 获取全国群聊的数量
     *
     * @return 群聊的数量
     */
    Integer getGlobalGroupSize();

    /**
     * 新版本获取指定地区可用的群聊，包括已满员的群组
     * 用户不在黑名单中
     *
     * @param areaCode 地区编码
     * @param userId   用户ID
     * @return 群聊信息
     */
    List<GroupInfoBO> getLastEnableGroupByArea(@Param("areaCode") String areaCode, @Param("userId") Long userId);

    /**
     * 获取群组列表
     *
     * @param areaCode 请求
     * @param page     分页
     * @return 群列表
     */
    List<GroupInfoBO> getGroupList(@Param("areaCode") String areaCode, @Param("page") Page<GroupInfoBO> page);
}
