package com.bxm.localnews.im.domain.group;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.localnews.im.bo.ImGroupMemberInfoBO;
import com.bxm.localnews.im.dto.group.GroupMemberListItemDTO;
import com.bxm.localnews.im.dto.group.MemberInfoDTO;
import com.bxm.localnews.im.entity.group.ImGroupMemberEntity;
import com.bxm.localnews.im.param.group.GroupMemberQueryParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 群组成员信息 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-17
 */
@Mapper
public interface ImGroupMemberMapper extends BaseMapper<ImGroupMemberEntity> {

    /**
     * 查询用户是否在某个群组中
     *
     * @param groupId 群组ID
     * @param userId  用户ID
     * @return 群组成员信息
     */
    ImGroupMemberEntity getMemberInfo(@Param("groupId") Long groupId, @Param("userId") Long userId);

    /**
     * 查询用户处于激活状态的加入的群组信息
     *
     * @param userId 用户ID
     * @return 群组成员信息
     */
    ImGroupMemberInfoBO getUserActiveGroup(Long userId);

    /**
     * 根据群组和用户ID更新数据
     *
     * @param entity 更新的实体信息
     */
    int updateByGroupIdAndUserId(ImGroupMemberEntity entity);

    /**
     * 获取所有还在群中的成员
     *
     * @param groupId 群组ID
     * @return 群成员ID
     */
    List<MemberInfoDTO> queryAllMember(Long groupId);

    /**
     * 分页查询群成员信息
     *
     * @param page  分页参数
     * @param param 查询条件
     * @return 分页结果
     */
    IPage<GroupMemberListItemDTO> queryMemberByPage(@Param("page") Page<GroupMemberListItemDTO> page,
                                                    @Param("param") GroupMemberQueryParam param);

    /**
     * 查询群内不同用户类型的用户总数
     *
     * @param groupId  群组ID
     * @param userType 用户类型
     * @return 统计结果
     */
    int countByUserType(@Param("groupId") Long groupId, @Param("userType") Integer userType);

    /**
     * 更新群组成员信息
     *
     * @param userId   用户ID
     * @param nickName 用户昵称
     * @param headImg  用户头像
     * @return
     */
    int updateMemberInfo(@Param("userId") Long userId,
                         @Param("nickName") String nickName,
                         @Param("headImg") String headImg);

    /**
     * 查询群组内处于激活状态的用户
     *
     * @param groupId 群组ID
     * @param num     查询数量
     * @return 群组成员数据
     */
    List<ImGroupMemberEntity> queryActiveMember(@Param("groupId") Long groupId, @Param("num") Integer num);

    /**
     * 查询群成员信息
     *
     * @param groupId       群组ID
     * @param userType      用户类型
     * @param excludeUserId 排除的用户
     * @param num           删除数量
     * @return 操作结果
     */
    List<ImGroupMemberEntity> queryMember(@Param("groupId") Long groupId,
                                          @Param("userType") Integer userType,
                                          @Param("excludeUserId") Long excludeUserId,
                                          @Param("num") Integer num);


    /**
     * 查询用户处于激活状态的加入的群组的id
     *
     * @param userId 用户ID
     * @return 群组id信息
     */
    List<Long> getUserActiveGroupIds(Long userId);
}
