package com.bxm.localnews.im.domain.group;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.localnews.im.entity.group.ImGroupNoticeEntity;
import org.apache.ibatis.annotations.Mapper;

/**
 * <p>
 * 群组公告信息 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-17
 */
@Mapper
public interface ImGroupNoticeMapper extends BaseMapper<ImGroupNoticeEntity> {

    /**
     * 设置群组的历史公告为不可用
     *
     * @param groupId 群组ID
     * @return 影响函数
     */
    int disableHistory(Long groupId);

    /**
     * 查询群组内可用的公告
     *
     * @param groupId 群组ID
     * @return 公告信息
     */
    ImGroupNoticeEntity getEnableNotice(Long groupId);
}
