package com.bxm.localnews.im.domain.group;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.localnews.im.entity.group.ImGroupTotalEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 群组统计数据 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-17
 */
@Mapper
public interface ImGroupTotalMapper extends BaseMapper<ImGroupTotalEntity> {

    /**
     * 增加统计数据
     *
     * @param entity 群组统计数据
     * @return 操作行数
     */
    int addCount(ImGroupTotalEntity entity);

    /**
     * 添加参与人员，防止超员
     *
     * @param groupId 群组ID
     * @return 影响函数
     */
    int addMember(@Param("groupId") Long groupId, @Param("num") Integer num);
}
