package com.bxm.egg.user.enums;

import com.bxm.egg.common.constant.CommonI18NConstant;

import static com.bxm.egg.common.constant.CommonI18NConstant.UNAUTHORIZED;

/**
 * 鉴权码枚举
 *
 * @author liujia
 */
public enum AuthCodeEnum {

    /**
     * 聊天室-是否可以抢红包
     */
    PICK_RED_PACKAGE(0, UNAUTHORIZED, AuthTypeEnum.OPERATION),

    /**
     * 聊天室-禁止在群聊中发言
     */
    BANNED_TO_POST(1, UNAUTHORIZED, AuthTypeEnum.OPERATION),

    /**
     * 聊天室-阶段禁言（禁言一小时、一天）
     */
    BANNED_PHASE(2, CommonI18NConstant.BANNED_PHASE, AuthTypeEnum.OPERATION),

    /**
     * 聊天室-解除用户禁言
     */
    UNBANNED_TO_POST(3, CommonI18NConstant.NONE, AuthTypeEnum.OPERATION),

    /**
     * 聊天室-撤回用户发言
     */
    RECALL_MESSAGE(4, CommonI18NConstant.NONE, AuthTypeEnum.OPERATION),

    /**
     * 禁止评论
     */
    FORBID_COMMENT(5, CommonI18NConstant.FORBID_COMMENT, AuthTypeEnum.BLOCK),

    /**
     * 禁止发帖
     */
    FORBID_POST(6, CommonI18NConstant.FORBID_POST, AuthTypeEnum.BLOCK),

    /**
     * 禁止发小纸条
     */
    FORBID_NOTE(7, CommonI18NConstant.FORBID_NOTE, AuthTypeEnum.BLOCK),


    /**
     * 帖子增加评论
     */
    FORUM_COMMENT_MANAGE(8, CommonI18NConstant.NONE, AuthTypeEnum.OPERATION),

    /**
     * 马甲号管理员
     */
    VIRTUAL_ADMIN_MANAGE(9, CommonI18NConstant.NONE, AuthTypeEnum.OPERATION),

    ;

    /**
     * 权限位在权限编码中的bit位置
     * 从0开始，每64位新增一个group
     */
    public int index;

    /**
     * 显示的消息编码，详见{@link CommonI18NConstant}
     */
    public String msgCode;

    /**
     * 权限类型
     */
    public AuthTypeEnum type;

    AuthCodeEnum(int index, String msgCode, AuthTypeEnum type) {
        this.index = index;
        this.msgCode = msgCode;
        this.type = type;
    }

    /**
     * 根据权限索引获取对应的编码枚举
     *
     * @param index 权限索引
     * @return 权限枚举
     */
    public static AuthCodeEnum getByIndex(Integer index) {
        for (AuthCodeEnum authCodeEnum : AuthCodeEnum.values()) {
            if (index == authCodeEnum.index) {
                return authCodeEnum;
            }
        }
        return null;
    }
}