package com.bxm.egg.user.enums;

import lombok.Getter;

/**
 * 用户成就勋章枚举
 *
 * @author wzy
 * @date 2021年03月05日09:34:46
 */
@Getter
public enum UserAchievementMedalStatusEnum {
    /**
     * 未解锁
     */
    UN_LOCK(0, "未解锁"),
    /**
     * 已获得可升级
     */
    WAIT_UP_LEVEL(1, "已获得可升级"),
    /**
     * 已获得不可升级
     */
    NOT_UP_LEVEL(2, "已获得不可升级");

    /**
     * 状态码
     */
    private Integer code;

    /**
     * 描述
     */
    private String description;

    UserAchievementMedalStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }
}
