package com.bxm.egg.user.model;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * 处理结果传输对象
 *
 * @author liujia
 * @date 2020/6/3 17:43
 **/
@Data
@Builder
public class ResultDTO {

    @Tolerate
    public ResultDTO() {
    }

    private String result;

    private Boolean success;

    private String title;

    public void appendResult(String result) {
        if (this.result == null) {
            this.result = result;
        }

        this.result = this.result + "," + result;
    }
}
