package com.bxm.egg.user.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.egg.user.model.dto.invite.egg.InviteUserListDTO;
import com.bxm.egg.user.model.entity.EggInviteEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 邀请好友送鸡蛋记录表【六享】 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-14
 */
@Mapper
public interface EggInviteMapper extends BaseMapper<EggInviteEntity> {

    /**
     * 获取被邀请用户
     *
     * @param userId 用户id
     * @param count  数量
     * @return 被邀请用户头像
     */
    List<String> getInviteUserHeadImg(@Param("userId") Long userId,
                                      @Param("count") int count);

    IPage<InviteUserListDTO> queryInviteByPage(@Param("page") Page<InviteUserListDTO> page,
                                               @Param("userId") Long userId);

    void delInviteInfoByUserId(Long userId);

    void insertInviteInfo(EggInviteEntity eggInviteEntity);
}
