package com.bxm.egg.user.mapper;

import com.bxm.egg.user.model.param.InviteRecordParam;
import com.bxm.egg.user.model.vo.InviteRecord;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author zhaoyadong 2019/3/5 19:50
 * @desc
 */
@Mapper
public interface InviteRecordMapper {

    /**
     * 获取对应用户的邀请信息
     */
    List<InviteRecord> queryInviteRecords(@Param("userId") Long userId, @Param("status") Byte status);

    /**
     * 获取用户的邀请关系信息
     */
    List<InviteRecord> queryUserInviteRecord(InviteRecordParam inviteRecordParam);

    /**
     * 添加邀请关系
     */
    int addInviteRecord(InviteRecord inviteRecord);

    /**
     * 更新邀请关系金额
     */
    Boolean updateInviteCash(@Param("userId") Long inviteUserId,
                             @Param("invitedUserId") Long invitedUserId,
                             @Param("cash") BigDecimal cash);

    /**
     * 更新邀请关系
     */
    int updateInviteRecord(InviteRecord inviteRecord);

    InviteRecord getInviteRecordByUser(InviteRecordParam inviteRecordParam);

    /**
     * 判断是否是协会人员
     */
    int checkIsAssociation(@Param("userId") Long userId);

    /**
     * 获取邀请赏金
     */
    List<Map<String, Object>> getIdAndInvitedAward(@Param("userId") Long inviteUserId, @Param("invitedUserId") Long invitedUserId);

    /**
     * 邀请关系失效
     */
    Boolean removeInviteRecord(@Param("userId") Long userId, @Param("invitedUserId") Long invitedUserId);

    /**
     * 移除用户表的邀请人id
     */
    Boolean removeUserInvite(@Param("userId") Long userId);

    /**
     * 更新用户为可领取红包状态
     * @param userId 用户id
     * @return 更新结果
     */
    int updateReceiveRedPacket(@Param("userId") Long userId);

}
