package com.bxm.egg.user.mapper;

import com.bxm.egg.user.model.entity.TempInviteBindEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.egg.user.model.param.invite.InviteBindParam;
import org.apache.ibatis.annotations.Mapper;

import java.util.Date;

/**
 * <p>
 * 临时邀请绑定表 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-11-09
 */
@Mapper
public interface TempInviteBindMapper extends BaseMapper<TempInviteBindEntity> {

    /**
     * 是否存在绑定关系
     *
     * @param inviteBindParam 请求入参
     * @return 结果
     */
    int isExist(InviteBindParam inviteBindParam);

    /**
     * 删除临时邀请绑定
     *
     * @param unionId 请求入参
     * @return 结果
     */
    int delInviteBindByUnionId(String unionId);

    /**
     * 删除此时间之前的临时信息
     *
     * @param date 时间
     */
    void delInviteBindByDate(Date date);
}
