package com.bxm.egg.user.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.egg.user.model.param.UserCoverListParam;
import com.bxm.egg.user.model.vo.UserCover;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface UserCoverMapper {


    int insertSelective(UserCover record);

    UserCover selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserCover record);

    int updateByPrimaryKey(UserCover record);

    /**
     * 根据状态来获取最新一条数据
     *
     * @param userId 用户id
     * @param status 状态
     * @return 结果
     */
    UserCover getLastCoverInfoByStatus(@Param("userId") Long userId, @Param("status") Integer status);

    /**
     * 获取封面列表
     *
     * @param param
     * @return
     */
    IPage<UserCover> getUserCoverList(@Param("page") IPage<UserCover> queryParam,
                                      @Param("param") UserCoverListParam param);
}