package com.bxm.egg.user.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.egg.user.model.param.earnings.UserEarningsParam;
import com.bxm.egg.user.model.vo.UserEarnings;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface UserEarningsMapper {
    int deleteByPrimaryKey(Long id);

    int insertSelective(UserEarnings record);

    UserEarnings selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserEarnings record);

    /**
     * 获取用户收益列表
     *
     * @param param 请求参数
     * @return 用户收益列表
     */
    IPage<UserEarnings> getUserEarningsList(@Param("page") IPage<UserEarnings> page,
                                            @Param("param") UserEarningsParam param);

    /**
     * 获取用户收益流水
     *
     * @param userId     用户id
     * @param relationId 收益类型对应的id
     * @return 用户收益
     */
    UserEarnings getEarningsByTypeAndRelationId(@Param("userId") Long userId,
                                                @Param("relationId") Long relationId);
}