package com.bxm.egg.user.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.egg.user.model.param.FollowListParam;
import com.bxm.egg.user.model.param.UserFollowParam;
import com.bxm.egg.user.model.param.UserIdFollowParam;
import com.bxm.egg.user.model.vo.UserFollow;
import com.bxm.egg.user.model.vo.UserFollowRecord;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface UserFollowMapper {

    int insertFollowed(UserFollowRecord record);

    int updateFollowedStatus(UserFollowRecord record);

    UserFollowRecord getFollowedRecord(@Param("userId") Long userId, @Param("followedUserId") Long followedUserId);


    List<Long> getFollowedUserIdList(@Param("userId") Long userId);

    IPage<UserFollow> queryFollowByPage(@Param("page") IPage<UserFollow> page,
                                        @Param("param") UserFollowParam param);

    List<Long> getFollowedUserIds(UserIdFollowParam param);

    /**
     * 根据请求参数进行搜索 我关注的列表
     *
     * @param param 搜搜参数
     * @return 我关注的列表
     */
    List<UserFollow> searchFollow(FollowListParam param);
}

