package com.bxm.egg.user.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.egg.user.model.dto.info.manage.UserInfoManageDTO;
import com.bxm.egg.user.model.dto.manage.info.UserManageListDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.manage.info.UserManageQueryParam;
import com.bxm.egg.user.model.vo.UserStatisticsBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 用户表 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-14
 */
@Mapper
public interface UserInfoMapper extends BaseMapper<UserInfoEntity> {

    /**
     * 查询用户信息列表
     *
     * @param page  分页参数
     * @param param 查询入参
     * @return 分页用户信息列表
     */
    IPage<UserManageListDTO> queryUserInfoList(IPage<UserManageListDTO> page,
                                               @Param("param") UserManageQueryParam param);

    /**
     * 查询用户信息列表通过用户id和昵称
     *
     * @param userId   用户id
     * @param nickname 昵称
     * @return 用户信息列表
     */
    List<UserInfoManageDTO> selectUserInfoManageList(@Param("userId") Long userId,
                                                     @Param("nickname") String nickname);

    /**
     * 统计新注册人数
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return 注册数量统计
     */
    List<UserStatisticsBean> regUserCounter(@Param("startTime") Date startTime,
                                            @Param("endTime") Date endTime);

    /**
     * 统计迁移人数
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return 迁移人数信息
     */
    List<UserStatisticsBean> migrationUserCounter(@Param("startTime") Date startTime,
                                                  @Param("endTime") Date endTime);

    /**
     * 根据用户名查询用户ID
     *
     * @param userName 用户名称
     * @return 用户ID
     */
    Long selectByUserName(@Param("userName") String userName);

    /**
     * 获取用户id，根据手机号
     *
     * @param phone 手机号
     * @return id
     */
    Long getUserIdByPhone(String phone);
}
