package com.bxm.egg.user.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.egg.user.model.param.UserInvitePageParam;
import com.bxm.egg.user.model.vo.Tuple;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.egg.user.model.vo.UserInviteOrderVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface UserInviteHistoryMapper {
    int insert(UserInviteHistoryBean record);

    UserInviteHistoryBean selectByPrimaryKey(Long id);

    /**
     * 更新被邀请用户的VIP状态
     *
     * @param userId 被邀请人ID
     * @return 更新结果
     */
    int updateInvitedUserIdVip(@Param("userId") Long userId);

    /**
     * 查询被邀请人的记录信息
     *
     * @param userId ： 用户id
     * @return
     */
    UserInviteHistoryBean selectByUserId(@Param("userId") Long userId);

    /**
     * 更新师徒邀请关系
     *
     * @param userInviteHistoryBean
     * @return 更新结果条数
     */
    int updateInviteSelective(UserInviteHistoryBean userInviteHistoryBean);

    /**
     * 获取用户的收徒统计数据
     * 版本3.10.0只展示一级徒弟，并且不展示内容徒弟
     *
     * @param userId 用户ID
     * @return 每日收徒数量统计
     */
    List<Tuple> getCollect(Long userId);

    /**
     * 获取不同等级的收徒人数
     *
     * @param userId ： 用户id
     * @param level  ： 等级
     * @return
     */
    Integer getCollectLevel(@Param("userId") Long userId, @Param("level") Integer level);

    /**
     * 根据日期区间统计所有用户的收徒信息
     *
     * @param startTime 起始时间
     * @param endTime   截止时间
     * @return 收徒信息结果
     */
    List<Tuple> getCollectByDate(@Param("startTime") Date startTime,
                                 @Param("endTime") Date endTime);

    /**
     * 获取某个用户的所有收徒数量
     *
     * @param userId
     * @return
     */
    Tuple getCollectAll(@Param("userId") Long userId);

    /**
     * 分页获取邀请徒弟信息
     *
     * @param param 分页参数
     * @return 分页结果
     */
    IPage<UserInviteHistoryBean> queryByPage(@Param("page") IPage<UserInviteHistoryBean> page,
                                             @Param("param") UserInvitePageParam param);

    /**
     * 获取最近邀请的徒弟头像列表
     *
     * @param userId 用户ID
     * @param limit  查询数量
     * @return 徒弟头像列表
     */
    List<String> getLastInviteHeadImg(@Param("userId") Long userId, @Param("limit") int limit);

    /**
     * 更新邀请记录的标题字段
     *
     * @param entity 记录实体
     * @return 更新结果
     */
    int updateTitle(UserInviteHistoryBean entity);

    /**
     * 查询relationId不为空，但是标题为空的记录
     *
     * @return 符合条件的记录
     */
    List<UserInviteHistoryBean> queryEmptyTitleRecord();

    /**
     * 获取收徒排名前num的大哥
     *
     * @param num          : 多少名
     * @param locationCode ： 地区编码
     * @return 排行榜信息
     */
    List<UserInviteOrderVO> getInviteOrderTen(@Param("num") Integer num, @Param("locationCode") String locationCode,
                                              @Param("userIds") List<Long> userIds);

    /**
     * 根据用户id获取收徒列表
     *
     * @param userId ： 用户id
     * @return ： 用户信息
     */
    List<UserInviteHistoryBean> queryListAllByUid(@Param("userId") Long userId);
}