package com.bxm.egg.user.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.egg.user.model.entity.UserLoginHistoryEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 用户登录历史表 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-14
 */
@Mapper
public interface UserLoginHistoryMapper extends BaseMapper<UserLoginHistoryEntity> {

    /**
     * 获取用户登录设备列表
     *
     * @param userId 用户id
     * @param date   时间
     * @return 设备列表
     */
    List<Long> getUserLoginEquipmentList(@Param("userId") Long userId, @Param("date") Date date);
}
