package com.bxm.egg.user.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.egg.user.model.vo.UserStatisticsBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 用户统计信息表 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-14
 */
@Mapper
public interface UserStatisticsMapper extends BaseMapper<UserStatisticsEntity> {
    int countRegUser(@Param("startTime") String startTime, @Param("endTime") String endTime);

    /**
     * 时间段内的注册用户
     *
     * @param startTime 开始时间
     * @param endTime   截止时间
     * @return 注册用户统计信息
     */
    List<UserStatisticsBean> regUser(@Param("startTime") Date startTime, @Param("endTime") Date endTime);

    /**
     * 时间段内激活的VIP信息
     *
     * @param startTime 开始时间
     * @param endTime   截止时间
     * @return VIP用户统计信息
     */
    List<UserStatisticsBean> vipUser(@Param("startTime") Date startTime, @Param("endTime") Date endTime);

    int addAttentionNum(@Param("userId") Long userId, @Param("attentionCount") Integer attentionCount);

    int addFanNum(@Param("userId") Long userId, @Param("fanCount") Integer fanCount);

    /**
     * 更新用户的温暖值（温暖值最小为0）
     *
     * @param userId           用户id
     * @param warmValue        温暖值
     * @param defaultWarmValue 默认的最小温暖值
     * @return 结果
     */
    int updateUserWarmInfo(@Param("userId") Long userId,
                           @Param("warmValue") Integer warmValue,
                           @Param("defaultWarmValue") Integer defaultWarmValue);

    /**
     * 操作用户统计值
     *
     * @param userId             用户id
     * @param userStatisticsType 统计值类型
     * @param operateType        操作类型
     * @param operateNum         操作数量
     * @return 影响行数
     */
    int operateUserStatistics(@Param("userId") Long userId,
                              @Param("userStatisticsType") Integer userStatisticsType,
                              @Param("operateType") Integer operateType,
                              @Param("operateNum") Integer operateNum);

}
