package com.bxm.egg.user.mapper;

import com.bxm.egg.user.model.vo.UserVisit;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface UserVisitMapper {

	int insert(UserVisit record);

	int insertSelective(UserVisit record);

	int update(UserVisit userVisit);

	/**
	 * 根据日期分页来查询访客记录，由于和常规的分页不一样，所以需要自定义分页参数
	 *
	 * @param start
	 * @param num
	 * @return
	 */
	List<UserVisit> queryPageByVisitDate(@Param("start") Integer start,
										 @Param("num") Integer num,
										 @Param("userId") Long userId);

	/**
	 * 所有的浏览总量
	 *
	 * @param userId
	 * @return
	 */
	int selectCountByUserId(Long userId);

	/**
	 * 所有的浏览总量
	 *
	 * @param userId
	 * @return
	 */
	int selectCountByTime(@Param("userId") Long userId,
						  @Param("startTime") Date startTime);

	/**
	 * 查询某用户最近三个访客的头像（去重）
	 *
	 * @param userId
	 * @param limit
	 * @return
	 */
	List<UserVisit> selectLastVisitorHeadImg(@Param("userId") Long userId,
											 @Param("limit") int limit);

	/**
	 * 更新用户冗余信息
	 * @param userId
	 * @param nickname
	 * @param headImg
	 * @param sex
	 */
	void updateUserInfo(@Param("tableName") String tableName,
						@Param("visitUserId") Long userId,
						@Param("visitUserNickname") String nickname,
						@Param("visitUserHeadImg") String headImg,
						@Param("visitUserSex") Byte sex);

}