package com.bxm.egg.user.mapper;

import com.bxm.egg.user.model.entity.UserWechatDelBindLogEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 用户微信删除绑定记录 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2022-01-11
 */
@Mapper
public interface UserWechatDelBindLogMapper extends BaseMapper<UserWechatDelBindLogEntity> {

    /**
     * 获取最新解绑信息
     *
     * @param userId  用户id
     * @param unionId 微信标识
     * @return 返回结果
     */
    UserWechatDelBindLogEntity getLastDelBindLog(@Param("userId") Long userId, @Param("unionId") String unionId);
}
