package com.bxm.egg.user.mapper.auth;

import com.bxm.egg.user.model.vo.auth.UserAuthIdBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface UserAuthIdMapper {
    int deleteByPrimaryKey(Long id);

    int insert(UserAuthIdBean record);

    int insertSelective(UserAuthIdBean record);

    UserAuthIdBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserAuthIdBean record);

    int updateByPrimaryKey(UserAuthIdBean record);

    /**
     * 移除单个用户权限编码信息
     * @param userId     用户ID
     * @param authCode   权限编码
     * @param resourceId 资源ID
     * @return 移除数量
     */
    int removeAuthId(@Param("userId") Long userId,
                     @Param("authCode") Integer authCode,
                     @Param("resourceId") String resourceId);

    /**
     * 移除用户所有的权限编码信息
     * @param userId   用户ID
     * @param authCode 权限编码
     * @return 移除数量
     */
    int removeAuth(@Param("userId") Long userId,
                   @Param("authCode") Integer authCode);

    /**
     * 查询用户持有的权限数据
     * @param userId 用户ID
     * @return 持有权限资源数据
     */
    List<UserAuthIdBean> queryAuthIds(Long userId);
}