package com.bxm.egg.user.mapper.auth;

import com.bxm.egg.user.model.vo.auth.UserRoleBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface UserRoleMapper {
    int deleteByPrimaryKey(Long id);

    int insert(UserRoleBean record);

    int insertSelective(UserRoleBean record);

    UserRoleBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserRoleBean record);

    int updateByPrimaryKey(UserRoleBean record);

    /**
     * 获取用户的角色列表
     * @param userId 用户ID
     * @return 角色列表
     */
    List<UserRoleBean> getUserRoles(Long userId);

    /**
     * 移除用户角色信息
     * @param userId   用户ID
     * @param roleCode 角色编码
     * @return 影响行数
     */
    int removeUserRole(@Param("userId") Long userId, @Param("roleCode") String roleCode);
}