package com.bxm.egg.user.mapper.medal;


import com.bxm.egg.user.model.dto.medal.MainPageMedalImageDTO;
import com.bxm.egg.user.model.entity.medal.UserMedalRelationInfoEntity;
import com.bxm.egg.user.model.vo.medal.CustomMedalDetailVO;
import com.bxm.egg.user.model.vo.medal.SingleCustomMedalBaseVO;
import com.bxm.egg.user.model.vo.medal.SinglePreviewMedalVO;
import com.bxm.egg.user.model.vo.medal.manage.CustomMedalVO;
import com.bxm.egg.user.model.vo.medal.manage.MedalMiniVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface UserMedalRelationInfoMapper {
    int deleteByPrimaryKey(Long id);

    int insert(UserMedalRelationInfoEntity record);

    int insertSelective(UserMedalRelationInfoEntity record);

    UserMedalRelationInfoEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserMedalRelationInfoEntity record);

    int updateByPrimaryKey(UserMedalRelationInfoEntity record);

    /**
     * 获取用户所有已经获得的成就勋章信息
     *
     * @param userId 用户id
     * @return 用户已经获得的成就勋章信息
     */
    List<UserMedalRelationInfoEntity> getUserMaxLevelAchievementMedal(@Param("userId") Long userId);

    /**
     * 统计用户的成就勋章总数
     *
     * @param userId 用户id
     * @return 成就勋章勋章总数
     */
    int countUserAchievementMedalNum(@Param("userId") Long userId);

    /**
     * 统计用户的定制勋章总数
     *
     * @param userId 用户id
     * @return 定制勋章总数
     */
    int countUserCustomMedalNum(@Param("userId") Long userId);

    /**
     * 获取他人定制勋章信息
     *
     * @param userId 用户id 用户id
     * @return 他人定制勋章信息
     */
    List<SingleCustomMedalBaseVO> getOtherUserCustomMedalInfo(@Param("userId") Long userId);

    /**
     * 获取我的定制勋章信息
     *
     * @param userId 用户id
     * @return 定制勋章列表
     */
    List<SingleCustomMedalBaseVO> getMyUserCustomMedalInfo(@Param("userId") Long userId);


    /**
     * 获取用户勋章获得记录通过用户id和勋章id
     *
     * @param userId  用户id
     * @param medalId 勋章id
     * @return 用户获得记录
     */
    UserMedalRelationInfoEntity getByUserIdAndMedalId(@Param("userId") Long userId,
                                                      @Param("medalId") Long medalId);

    /**
     * 通过用户id和父勋章id获取用户获得该勋章的最高等级
     *
     * @param userId        用户id
     * @param medalParentId 勋章父id
     * @return 获取勋章记录列表
     */
    UserMedalRelationInfoEntity getUserMaxLevelMedalInfo(@Param("userId") Long userId,
                                                         @Param("medalParentId") Long medalParentId);

    /**
     * 获取定制勋章详情
     *
     * @param userId  用户id
     * @param medalId 勋章id
     * @return 定制勋章详情
     */
    CustomMedalDetailVO getCustomMedalDetail(@Param("userId") Long userId,
                                             @Param("medalId") Long medalId);


    /**
     * 获取所有的有效的定制勋章
     *
     * @param userId 用户id
     * @return 勋章列表
     */
    List<SinglePreviewMedalVO> getAllUsableCustomMedalInfo(@Param("userId") Long userId);


    /**
     * 获取所有已佩戴勋章列表
     *
     * @param userId 用户id
     * @return 勋章列表
     */
    List<SinglePreviewMedalVO> getAllWearMedalInfo(@Param("userId") Long userId);

    /**
     * 佩戴勋章（更新勋章佩戴状态）
     *
     * @param userId    用户id
     * @param medalId   勋章id
     * @param wearOrder 佩戴勋章的顺序
     * @return 影响行数
     */
    int wearMedal(@Param("userId") Long userId,
                  @Param("medalId") Long medalId,
                  @Param("wearOrder") Integer wearOrder);

    /**
     * 卸下用户所有的勋章
     *
     * @param userId 用户id
     * @return 影响行数
     */
    int unWearUserMedal(@Param("userId") Long userId);


    /**
     * 获取用户获得的所有勋章
     *
     * @param userId 用户id 用户id
     * @return 用户所有的获得勋章的列表
     */
    List<MainPageMedalImageDTO> getRelationListByUserId(@Param("userId") Long userId);


    /**
     * 获取用户父勋章id下面所有的子勋章信息
     *
     * @param userId        用户id
     * @param medalParentId 父勋章id
     * @return 用户获得所有子勋章信息
     */
    List<UserMedalRelationInfoEntity> getUserMedalListByUserAndParentId(@Param("userId") Long userId,
                                                                        @Param("medalParentId") Long medalParentId);

    /**
     * 获取用户的成就勋章列表
     *
     * @param userId 用户id
     * @return 成就勋章列表
     */
    List<MedalMiniVO> getUserAchievementMedalList(@Param("userId") Long userId);

    /**
     * 获取用户的定制勋章列表
     *
     * @param userId 用户id
     * @return 定制勋章列表
     */
    List<CustomMedalVO> getUserCustomMedalList(@Param("userId") Long userId);
}