package com.bxm.egg.user.mapper.warmlevel;

import com.bxm.egg.user.model.vo.warmlevel.UserLevelLog;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface UserLevelLogMapper {

    int deleteByPrimaryKey(Long id);

    int insert(UserLevelLog record);

    int insertSelective(UserLevelLog record);

    UserLevelLog selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserLevelLog record);

    int updateByPrimaryKey(UserLevelLog record);

    /**
     * 获取用户等级日志条数
     *
     * @param userId 用户id
     * @return 数量
     */
    Integer getUserLevelCount(@Param("userId") Long userId);

    /**
     * 获取用户等级日志条数
     *
     * @param userId 用户id
     * @return 数量
     */
    List<UserLevelLog> getUserLevelList(@Param("userId") Long userId);

    /**
     * 批量插入日志等级信息
     *
     * @param userLevelLogs 日志信息
     */
    void batchInsertLog(@Param("list") List<UserLevelLog> userLevelLogs);
}