package com.bxm.egg.user.mapper.warmlevel;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.egg.user.model.param.warmlevel.UserWarmValueDetailParam;
import com.bxm.egg.user.model.vo.warmlevel.UserWarmValueFlow;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;

@Mapper
public interface UserWarmValueFlowMapper {
    int deleteByPrimaryKey(Long id);

    int insertSelective(UserWarmValueFlow record);

    UserWarmValueFlow selectByPrimaryKey(Long id);

    /**
     * 获取温暖值明细
     *
     * @param page                     分页参数
     * @param userWarmValueDetailParam 入参
     * @return 返回结果
     */
    IPage<UserWarmValueFlow> getWarmDetailListByUser(IPage<UserWarmValueFlow> page,
                                                     @Param("param") UserWarmValueDetailParam userWarmValueDetailParam);

    /**
     * 根据时间删除流水信息
     *
     * @param date 时间
     * @return 返回结果
     */
    int delWarmFlowByDate(@Param("date") Date date);
}