package com.bxm.egg.user.mapper.warmlevel;

import com.bxm.egg.user.model.vo.warmlevel.WarmEquityDetail;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface WarmEquityDetailMapper {

    /**
     * 根据等级获取权益信息
     *
     * @param level 等级
     * @return 权益信息
     */
    List<WarmEquityDetail> listWarmEquityByLevel(@Param("level") Integer level);

    /**
     * 获取权益列表
     *
     * @return 权益列表
     */
    List<WarmEquityDetail> getLevelEquityList();

    /**
     * 根据类型获取权益信息
     *
     * @return 权益列表
     */
    WarmEquityDetail getLevelEquityByType(@Param("type") String type);
}