package com.bxm.egg.user.mapper.warmlevel;

import com.bxm.egg.user.model.vo.warmlevel.WarmLevel;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface WarmLevelMapper {

    /**
     * 根据温暖值获取等级信息
     *
     * @param warmValue 温暖值
     * @return 等级信息
     */
    WarmLevel getWarmLevelByWarmValue(@Param("warmValue") Integer warmValue);

    /**
     * 获取所有等级信息
     *
     * @return 等级列表信息
     */
    List<WarmLevel> getWarmLevelList();


    /**
     * 根据用户id获取等级信息
     *
     * @param userId 用户id
     * @return 等级信息
     */
    WarmLevel getWarmLevelByUserId(@Param("userId") Long userId);

}