package com.bxm.egg.user.facade.dto;

import com.bxm.egg.common.enums.AuthCodeEnum;
import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@ApiModel(description = "用户拥有的鉴权资源信息")
@EqualsAndHashCode(callSuper = true)
@Data
public class UserAuthResourceDTO extends BaseBean {

    private static final long serialVersionUID = -5059079304191712592L;
    /**
     * @see AuthCodeEnum
     */
    @ApiModelProperty("鉴权码，具体解释详见SF")
    private Integer authCode;

    @ApiModelProperty("鉴权码对应访问资源限制，如果为空表示拥有权限即可访问所有相关数据")
    private List<String> resources;

    public UserAuthResourceDTO() {
    }

    public UserAuthResourceDTO(Integer authCode, List<String> resources) {
        this.authCode = authCode;
        this.resources = resources;
    }
}
