package com.bxm.egg.user.facade.mock;

import com.bxm.egg.user.facade.service.UserFollowFacadeService;
import lombok.extern.slf4j.Slf4j;

/**
 * 用户关注关系内部接口兜底
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/28 3:30 下午
 */
@Slf4j
public class UserFollowFacadeServiceMock implements UserFollowFacadeService {
    @Override
    public Boolean isFollow(Long userId, Long targetUserId) {

        log.error("获取用户是否关注服务失败，用户id: {}，目标用户id：{}", userId, targetUserId);
        return false;
    }

    @Override
    public Boolean hasFollowMsg(Long userId, Long targetUid) {

        log.error("获取用户是否有关注消息失败，用户id: {}，目标用户id：{}", userId, targetUid);
        return false;
    }

    @Override
    public void addHuolaFriends(Long userId, Long followUserId, Byte type) {

    }
}