package com.bxm.egg.user.facade.service;

/**
 * 用户是关注关系内部接口
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/28 2:55 下午
 */
public interface UserFollowFacadeService {
    /**
     * 是否关注
     *
     * @param userId       用户id
     * @param targetUserId 目标用户id
     * @return 是否关注
     */
    Boolean isFollow(Long userId, Long targetUserId);

    /**
     * 是否有关注消息
     *
     * @param userId    用户id
     * @param targetUid 目标用户id
     * @return 是否有关注消息
     */
    Boolean hasFollowMsg(Long userId, Long targetUid);

    /**
     * 添加火辣好友
     *
     * @param userId       用户id
     * @param followUserId 被关注用户
     */
    void addHuolaFriends(Long userId, Long followUserId, Byte type);
}