/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.integration;

import com.bxm.egg.facade.dto.LocationDetailDTO;
import com.bxm.egg.facade.service.LocationFacadeService;
import com.bxm.egg.user.dto.LocationDTO;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class LocationIntegrationService {
    @DubboReference(protocol="dubbo", mock="com.bxm.egg.user.integration.fallback.LocationFacadeServiceMock", cluster="failover", version="1.0.0", cache="lru", check=false, lazy=true)
    private LocationFacadeService locationFacadeService;

    public LocationDTO getLocationByGeocode(String code) {
        LocationDTO locationDTO = new LocationDTO();
        if (StringUtils.isBlank((CharSequence)code)) {
            locationDTO.setCode("371100000000");
            locationDTO.setName("\u65e5\u7167");
            locationDTO.setHot((byte)1);
            locationDTO.setLevel((byte)3);
            locationDTO.setLng(119.526888);
            locationDTO.setLat(35.416377);
            locationDTO.setFullName("\u5c71\u4e1c\u7701\u65e5\u7167\u5e02");
            return locationDTO;
        }
        LocationDetailDTO locationDetailDTO = this.locationFacadeService.getLocationDetailByCode(code);
        BeanUtils.copyProperties((Object)locationDetailDTO, (Object)locationDTO);
        return locationDTO;
    }
}

