/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.integration;

import com.bxm.egg.common.url.ProtocolFactory;
import com.bxm.egg.facade.dto.ClientConfigParam;
import com.bxm.egg.facade.service.ConfigClientFacadeService;
import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.mq.common.constant.MessageTypeEnum;
import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.egg.mq.common.message.AddFriendMessage;
import com.bxm.egg.mq.common.message.CustomMessage;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.mq.common.param.DingtalkMessage;
import com.bxm.egg.user.model.param.invite.ApplyFriendParam;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MessageFacadeIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(MessageFacadeIntegrationService.class);
    @DubboReference(protocol="dubbo", mock="com.bxm.egg.user.integration.fallback.MessageIntegrationServiceMock", cluster="failover", version="1.0.0", check=false, lazy=true)
    private MessageFacadeService messageFacadeService;
    @DubboReference(protocol="dubbo", mock="com.bxm.egg.user.integration.fallback.ConfigClientFacadeServiceMock", cluster="failover", version="1.0.0", check=false, lazy=true)
    private ConfigClientFacadeService configClientFacadeService;

    public void sendPushMessage(PushMessage message) {
        this.messageFacadeService.sendPushMessage(message);
    }

    public Integer getUnReadMessageNum(Long userId, MessageTypeEnum messageType) {
        return this.messageFacadeService.getUnreadMsg(userId, messageType);
    }

    public void addFollowMessage(Long userId) {
        PushMessage pushMessage = PushMessage.build();
        pushMessage.setPersistence(false);
        pushMessage.setTitle("\u65b0\u589e\u7c89\u4e1d");
        pushMessage.setContent("\u7c89\u4e1d+1");
        pushMessage.getPayloadInfo().setType(PushMessageEnum.ADD_FUNS.getType());
        this.addMessage(pushMessage, userId);
    }

    public void sendDingtalk(DingtalkMessage message) {
        this.messageFacadeService.sendDingtalk(message);
    }

    private void addMessage(PushMessage pushMessage, Long userId) {
        pushMessage.assign(userId);
        this.messageFacadeService.sendUserMessage(pushMessage);
    }

    @Async
    public void sendAddFriendMessage(Long senderId, String nickName, Long targetId) {
        PushMessage message = PushMessage.build((String)"\u8bf7\u6c42\u6dfb\u52a0\u597d\u53cb", (String)(nickName + "\u8bf7\u6c42\u6dfb\u52a0\u60a8\u4e3a\u86cb\u86cb\u4f73\u597d\u53cb"));
        message.assign(targetId);
        message.getPayloadInfo().setProtocol(ProtocolFactory.tabbarIndex().create().addAndRoid("message").addIos("TTMessageVC").build());
        this.messageFacadeService.sendPushMessage(message);
        AddFriendMessage addFriendMessage = AddFriendMessage.builder().applyUserId(senderId).content("\u670b\u53cb\uff0c\u6dfb\u52a0\u6211\u4e3a\u4f60\u7684\u597d\u53cb\u5427~").build();
        this.messageFacadeService.sendImMessage((CustomMessage)addFriendMessage, senderId, new Long[]{targetId});
    }

    @Async
    public void adoptFriendMessage(ApplyFriendParam applyFriendParam, String nickName) {
        PushMessage message = PushMessage.build((String)"\u6dfb\u52a0\u597d\u53cb\u6210\u529f", (String)("\u60a8\u5df2\u6210\u529f\u6dfb\u52a0" + nickName + "\u4e3a\u60a8\u7684\u597d\u53cb\uff0c\u73b0\u5728\u53ef\u4ee5\u53bb\u4e92\u52a8\u4e86~"));
        message.assign(applyFriendParam.getApplyUserId());
        message.getPayloadInfo().setProtocol(ProtocolFactory.appH5().url(this.getFriendsFramePage(applyFriendParam)).build());
        this.messageFacadeService.sendPushMessage(message);
    }

    private String getFriendsFramePage(ApplyFriendParam friendParam) {
        return this.configClientFacadeService.getSpecificConfig(ClientConfigParam.builder().key("toFriendsFarmUrl").chnl(friendParam.getChnl()).platform(friendParam.getPlatform()).curVer(friendParam.getCurVer()).build());
    }

    public MessageFacadeService getMessageFacadeService() {
        return this.messageFacadeService;
    }

    public ConfigClientFacadeService getConfigClientFacadeService() {
        return this.configClientFacadeService;
    }
}

