package com.bxm.egg.user.service.barrels;

import com.bxm.egg.user.param.NativeRecommendContext;

/**
 * 分桶抽象类，定义抽象类方法
 */
public abstract class AbstractBarrelChoose implements BarrelChoose {

    @Override
    public Boolean invoke(NativeRecommendContext nativeRecommendContext) {
        return doInvoke(nativeRecommendContext);
    }

    /**
     * 具体执行的方法
     *
     * @param nativeRecommendContext
     */
    protected Boolean doInvoke(NativeRecommendContext nativeRecommendContext) {
        return false;
    }

    @Override
    public int getOrder() {
        return BarrelOrder.get(this.getClass());
    }
}
