/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.service.impl;

import com.bxm.egg.user.param.NativeRecommendContext;
import com.bxm.egg.user.service.barrels.BarrelChoose;
import com.bxm.egg.user.service.barrels.BarrelSupport;
import com.bxm.egg.user.service.intefaces.BarrelHandler;
import com.google.common.collect.Maps;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Service;

@Service
public class BarrelInterceptorChain
implements ApplicationRunner,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private final Map<Class<? extends BarrelHandler>, List<BarrelChoose>> handlerMap = Maps.newHashMap();

    public void invoke(NativeRecommendContext nativeRecommendContext, BarrelHandler barrelHandler) {
        List<BarrelChoose> handlerList = this.getAccountFlowHandler(barrelHandler);
        for (BarrelChoose interceptor : handlerList) {
            if (!interceptor.invoke(nativeRecommendContext).booleanValue()) continue;
            return;
        }
    }

    protected List<BarrelChoose> getAccountFlowHandler(BarrelHandler barrelHandler) {
        return this.handlerMap.get(barrelHandler.getClass());
    }

    public void run(ApplicationArguments args) {
        Collection filters = this.applicationContext.getBeansOfType(BarrelChoose.class).values();
        List<BarrelChoose> result = filters.stream().sorted(Comparator.comparingInt(Ordered::getOrder)).collect(Collectors.toList());
        result.forEach(e -> {
            BarrelSupport support = (BarrelSupport)AnnotationUtils.getAnnotation((AnnotatedElement)AopUtils.getTargetClass((Object)e), BarrelSupport.class);
            if (null != support) {
                for (Class<? extends BarrelHandler> barrelHandler : support.value()) {
                    List<Object> barrelChooseList;
                    if (this.handlerMap.containsKey(barrelHandler)) {
                        barrelChooseList = this.handlerMap.get(barrelHandler);
                        barrelChooseList.add(e);
                        this.handlerMap.put(barrelHandler, barrelChooseList);
                        continue;
                    }
                    barrelChooseList = new ArrayList<BarrelChoose>();
                    barrelChooseList.add(e);
                    this.handlerMap.put(barrelHandler, barrelChooseList);
                }
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

