/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.service.impl;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.mapper.UserBlockMapper;
import com.bxm.egg.user.model.entity.UserBlock;
import com.bxm.egg.user.service.BlockUserService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class BlockUserServiceImpl
implements BlockUserService {
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private UserBlockMapper userBlockMapper;

    @Override
    public Boolean isBlockLimitUser(Long userId) {
        return StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(this.getBlockLimitRedisKey(userId)));
    }

    @Override
    public Boolean isRecommendLimitUser(Long userId) {
        return StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(this.getRecommendLimitRedisKey(userId)));
    }

    @Override
    @Cacheable(value={"listBlockUser"}, sync=true)
    public Map<Long, Integer> listBlockUser() {
        return this.userBlockMapper.listBlockUser().parallelStream().collect(Collectors.toMap(UserBlock::getUserId, UserBlock::getBlockType, (key1, key2) -> key1));
    }

    private KeyGenerator getBlockLimitRedisKey(Long userId) {
        return RedisConfig.USER_BLOCK_LIMIT.copy().appendKey((Object)userId);
    }

    private KeyGenerator getRecommendLimitRedisKey(Long userId) {
        return RedisConfig.RECOMMEND_BLOCK_LIMIT.copy().appendKey((Object)userId);
    }
}

