/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.auth.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bxm.egg.user.auth.UserBlockExpiredTaskService;
import com.bxm.egg.user.mapper.UserBlockExpiredTaskMapper;
import com.bxm.egg.user.model.entity.UserBlockExpiredTaskEntity;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserBlockExpiredTaskServiceImpl
implements UserBlockExpiredTaskService {
    private static final Logger log = LoggerFactory.getLogger(UserBlockExpiredTaskServiceImpl.class);
    @Resource
    private UserBlockExpiredTaskMapper userBlockExpiredTaskMapper;
    @Resource
    private SequenceCreater sequenceCreater;

    @Override
    public void addTask(Long userId, List<Integer> index, Date expiredTime) {
        UserBlockExpiredTaskEntity newTask = new UserBlockExpiredTaskEntity();
        newTask.setId(this.sequenceCreater.nextLongId());
        newTask.setExpiredTime(expiredTime);
        newTask.setUserId(userId);
        newTask.setAuthIndex(JSON.toJSONString(index));
        this.userBlockExpiredTaskMapper.insert((Object)newTask);
    }

    @Override
    public void removeTask(Long userId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(UserBlockExpiredTaskEntity::getUserId, (Object)userId);
        this.userBlockExpiredTaskMapper.delete((Wrapper)updateWrapper);
    }

    @Override
    public List<UserBlockExpiredTaskEntity> getExpiredTaskList() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.le(UserBlockExpiredTaskEntity::getExpiredTime, (Object)new Date());
        return this.userBlockExpiredTaskMapper.selectList((Wrapper)queryWrapper);
    }
}

