/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.mq.common.constant.MessageTypeEnum;
import com.bxm.egg.user.account.UserAccountService;
import com.bxm.egg.user.attribute.UserVisitService;
import com.bxm.egg.user.constant.UserEggRoleEnum;
import com.bxm.egg.user.info.UserBaseInfoService;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.info.UserInformationService;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.integration.MessageFacadeIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyDataStatisticsIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyInviteFoodsIntegrationService;
import com.bxm.egg.user.invite.UserInviteService;
import com.bxm.egg.user.invite.egg.UserEggInviteService;
import com.bxm.egg.user.medal.UserMedalService;
import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.bo.UserInformationBO;
import com.bxm.egg.user.model.dto.UserBaseInfoDTO;
import com.bxm.egg.user.model.dto.homepage.EggAccountDTO;
import com.bxm.egg.user.model.dto.homepage.EggAgentBusinessDTO;
import com.bxm.egg.user.model.dto.homepage.EggAgentInfoDTO;
import com.bxm.egg.user.model.dto.homepage.EggInviteDTO;
import com.bxm.egg.user.model.dto.homepage.EggPacketSimpleDTO;
import com.bxm.egg.user.model.dto.homepage.EggUserRoleDTO;
import com.bxm.egg.user.model.dto.info.UserBriefInfoDTO;
import com.bxm.egg.user.model.dto.info.UserDetailInfoDTO;
import com.bxm.egg.user.model.dto.medal.UserMedalDTO;
import com.bxm.egg.user.model.entity.UserAccountEntity;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.entity.UserInformationEntity;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.egg.user.properties.UserMedalProperties;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.egg.user.role.UserEggRoleService;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import com.bxm.sync.facade.dto.UserAssociateDataDTO;
import com.bxm.sync.facade.dto.UserCouponsStatisticsDTO;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserBaseInfoServiceImpl
implements UserBaseInfoService {
    private static final Logger log = LoggerFactory.getLogger(UserBaseInfoServiceImpl.class);
    private final UserInfoCacheService userInfoCacheService;
    private final UserProperties userProperties;
    private final UserMedalProperties userMedalProperties;
    private final UserInfoService userInfoService;
    private final UserStatisticsService userStatisticsService;
    private final UserInformationService userInformationService;
    private final UserVisitService userVisitService;
    private final MessageFacadeIntegrationService messageFacadeIntegrationService;
    private final UserInviteService userInviteService;
    private final UserMedalService userMedalService;
    private final UserWarmLevelService userWarmLevelService;
    private final UserEggRoleService userEggRoleService;
    private final SixEnjoyDataStatisticsIntegrationService sixEnjoyDataStatisticsIntegrationService;
    private final UserAccountService userAccountService;
    private final UserEggInviteService userEggInviteService;
    private final SixEnjoyInviteFoodsIntegrationService sixEnjoyInviteFoodsIntegrationService;

    @Override
    public List<UserBriefInfoDTO> getUserBriefInfoList(List<Long> userIdList) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.EMPTY_LIST;
        }
        return userIdList.stream().map(this::getUserBriefInfo).collect(Collectors.toList());
    }

    @Override
    public List<UserDetailInfoDTO> getUserDetailInfoList(List<Long> userIdList) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.EMPTY_LIST;
        }
        return userIdList.stream().map(this::getUserDetailInfo).collect(Collectors.toList());
    }

    private UserBriefInfoDTO getUserBriefInfo(Long userId) {
        UserBriefInfoDTO userBriefInfoDTO = new UserBriefInfoDTO();
        UserCacheInfoBO userCacheInfo = this.userInfoCacheService.load(userId);
        BeanUtils.copyProperties((Object)userCacheInfo, (Object)userBriefInfoDTO);
        UserEquityDTO userWarmLevelDTO = userCacheInfo.getUserWarmLevelDTO();
        boolean dazzling = userWarmLevelDTO != null && userWarmLevelDTO.getDazzling() != null && userWarmLevelDTO.getDazzling() != false;
        userBriefInfoDTO.setDazzling(Boolean.valueOf(dazzling));
        return userBriefInfoDTO;
    }

    @Override
    public UserBaseInfoDTO getUserPersonalCenterInfo(Long userId) {
        UserInfoEntity userInfoEntity = this.userInfoService.selectUserById(userId);
        UserStatisticsEntity userStatisticsEntity = this.userStatisticsService.selectUserStatisticsByUserId(userId);
        UserInformationEntity userInformationEntity = this.userInformationService.getUserInformationByUserId(userId);
        UserAccountEntity userAccountInfo = this.userAccountService.getUserAccountInfo(userId);
        if (null == userInfoEntity) {
            return null;
        }
        UserBaseInfoDTO userBaseInfoDTO = new UserBaseInfoDTO();
        userBaseInfoDTO.setNickname(StringUtils.isBlank((CharSequence)userInfoEntity.getNickname()) ? com.bxm.newidea.component.tools.StringUtils.hideMobile((String)userInfoEntity.getPhone()) : userInfoEntity.getNickname());
        userBaseInfoDTO.setHeadImg(StringUtils.isBlank((CharSequence)userInfoEntity.getHeadImg()) ? this.userProperties.getDefaultHeadImageUrl() : userInfoEntity.getHeadImg());
        userBaseInfoDTO.setForumNum(userStatisticsEntity.getPostNum());
        userBaseInfoDTO.setSex(userInfoEntity.getSex());
        userBaseInfoDTO.setAttentionNum(userStatisticsEntity.getAttentionNum());
        userBaseInfoDTO.setFanNum(userStatisticsEntity.getFanNum());
        userBaseInfoDTO.setPersonalProfile(userInformationEntity.getPersonalProfile());
        userBaseInfoDTO.setAllInterviewNum(this.userVisitService.getInterviewNumByUserId(userId));
        userBaseInfoDTO.setUnReadFanNum(this.messageFacadeIntegrationService.getUnReadMessageNum(userId, MessageTypeEnum.ADD_FUNS));
        userBaseInfoDTO.setTodayInterviewNum(this.userVisitService.getTodayVisitorNum(userId));
        userBaseInfoDTO.setInviteUserHeadImgList(this.userInviteService.getLastInviteUserHeadImgList(userId));
        int userMedalNum = this.userMedalService.getUserMedalNum(userId);
        UserMedalDTO userMedalDTO = new UserMedalDTO();
        userMedalDTO.setMedalIconUrl(this.userMedalProperties.getMyPageMedalUrl());
        userMedalDTO.setMedalNum(Integer.valueOf(userMedalNum));
        userBaseInfoDTO.setUserMedalDTO(userMedalDTO);
        userBaseInfoDTO.setEquityDTO(this.userWarmLevelService.getUserWarmInfoCache(userId).getEquityDTO());
        this.fillEggRoleInfo(userId, userBaseInfoDTO);
        this.fillEggAgentAndBusiness(userId, userBaseInfoDTO);
        this.fillEggPacketInfo(userId, userBaseInfoDTO, userAccountInfo);
        this.fillEggAccountInfo(userId, userBaseInfoDTO, userAccountInfo);
        this.fillInviteInfo(userId, userBaseInfoDTO);
        return userBaseInfoDTO;
    }

    @Override
    public UserBriefInfoDTO getSingleUserBriefInfo(Long userId) {
        return this.getUserBriefInfo(userId);
    }

    @Override
    public UserDetailInfoDTO getSingleUserDetailInfo(Long userId) {
        return this.getUserDetailInfo(userId);
    }

    @Override
    public Map<Long, UserBriefInfoDTO> getUserBriefMapInfo(List<Long> userIdList) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.emptyMap();
        }
        return this.getUserBriefInfoList(userIdList).stream().collect(Collectors.groupingBy(UserBriefInfoDTO::getUserId, Collectors.collectingAndThen(Collectors.toList(), value -> (UserBriefInfoDTO)value.get(0))));
    }

    @Override
    public Map<Long, UserDetailInfoDTO> getUserDetailMapInfo(List<Long> userIdList) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.emptyMap();
        }
        return this.getUserDetailInfoList(userIdList).stream().collect(Collectors.groupingBy(UserBriefInfoDTO::getUserId, Collectors.collectingAndThen(Collectors.toList(), value -> (UserDetailInfoDTO)value.get(0))));
    }

    private void fillInviteInfo(Long userId, UserBaseInfoDTO userBaseInfoDTO) {
        EggInviteDTO eggInviteDTO = new EggInviteDTO();
        eggInviteDTO.setInviteNum(Integer.valueOf(this.userEggInviteService.countInviteUser(userId)));
        eggInviteDTO.setInviteFoodsNum(this.sixEnjoyInviteFoodsIntegrationService.getReceiveFoods(userId));
        eggInviteDTO.setInviteHeadImgList(this.userEggInviteService.getUserInviteHeadImgList(userId));
        userBaseInfoDTO.setEggInviteDTO(eggInviteDTO);
    }

    private void fillEggAccountInfo(Long userId, UserBaseInfoDTO userBaseInfoDTO, UserAccountEntity userAccountInfo) {
        UserCouponsStatisticsDTO couponsStatistics = this.sixEnjoyDataStatisticsIntegrationService.getCouponsStatistics(userId);
        EggAccountDTO eggAccountDTO = new EggAccountDTO();
        eggAccountDTO.setEggCouponNum(couponsStatistics.getEggCoupon());
        eggAccountDTO.setFoodsNum(userAccountInfo.getUsableFoods());
        eggAccountDTO.setCardNum(couponsStatistics.getCardCoupon());
        userBaseInfoDTO.setEggAccountDTO(eggAccountDTO);
    }

    private void fillEggPacketInfo(Long userId, UserBaseInfoDTO userBaseInfoDTO, UserAccountEntity userAccountInfo) {
        EggPacketSimpleDTO eggPacketSimpleDTO = new EggPacketSimpleDTO();
        eggPacketSimpleDTO.setEnableAmount(userAccountInfo.getMoney());
        userBaseInfoDTO.setEggPacketSimpleDTO(eggPacketSimpleDTO);
    }

    private void fillEggAgentAndBusiness(Long userId, UserBaseInfoDTO userBaseInfoDTO) {
        EggUserRoleDTO eggUserRoleDTO = userBaseInfoDTO.getEggUserRoleDTO();
        List roleTypeList = eggUserRoleDTO.getRoleTypeList();
        if (roleTypeList.contains(UserEggRoleEnum.COMMUNITY_AGENT.getCode()) || roleTypeList.contains(UserEggRoleEnum.COUNTY_AGENT.getCode()) || roleTypeList.contains(UserEggRoleEnum.CITY_AGENT.getCode())) {
            UserAssociateDataDTO userAssociateData = this.sixEnjoyDataStatisticsIntegrationService.getUserAssociateData(userId, Boolean.valueOf(true));
            EggAgentInfoDTO eggAgentInfoDTO = new EggAgentInfoDTO();
            eggAgentInfoDTO.setCooperatorNum(userAssociateData.getAssociateNum());
            eggAgentInfoDTO.setDeviceNum(userAssociateData.getEquipmentNum());
            EggAgentBusinessDTO eggAgentBusinessDTO = new EggAgentBusinessDTO();
            eggAgentBusinessDTO.setDayOrderNum(userAssociateData.getOrderNumByDay());
            eggAgentBusinessDTO.setWeekOrderNum(userAssociateData.getOrderNumByWeek());
            eggAgentBusinessDTO.setMonthOrderNum(userAssociateData.getOrderNumByMonth());
            userBaseInfoDTO.setEggAgentInfoDTO(eggAgentInfoDTO);
            userBaseInfoDTO.setEggAgentBusinessDTO(eggAgentBusinessDTO);
        } else if (roleTypeList.contains(UserEggRoleEnum.BUSINESS.getCode())) {
            UserAssociateDataDTO userAssociateData = this.sixEnjoyDataStatisticsIntegrationService.getUserAssociateData(userId, Boolean.valueOf(false));
            EggAgentBusinessDTO eggAgentBusinessDTO = new EggAgentBusinessDTO();
            eggAgentBusinessDTO.setDayOrderNum(userAssociateData.getOrderNumByDay());
            eggAgentBusinessDTO.setWeekOrderNum(userAssociateData.getOrderNumByWeek());
            eggAgentBusinessDTO.setMonthOrderNum(userAssociateData.getOrderNumByMonth());
            userBaseInfoDTO.setEggAgentBusinessDTO(eggAgentBusinessDTO);
        }
    }

    private void fillEggRoleInfo(Long userId, UserBaseInfoDTO userBaseInfoDTO) {
        List<Integer> userRoleType = this.userEggRoleService.getUserRoleType(userId);
        EggUserRoleDTO eggUserRoleDTO = new EggUserRoleDTO();
        eggUserRoleDTO.setRoleTypeList(userRoleType);
        userBaseInfoDTO.setEggUserRoleDTO(eggUserRoleDTO);
    }

    private UserDetailInfoDTO getUserDetailInfo(Long userId) {
        UserDetailInfoDTO userDetailInfoDTO = new UserDetailInfoDTO();
        UserCacheInfoBO userCacheInfo = this.userInfoCacheService.load(userId);
        BeanUtils.copyProperties((Object)userCacheInfo, (Object)userDetailInfoDTO);
        UserEquityDTO userWarmLevelDTO = userCacheInfo.getUserWarmLevelDTO();
        boolean dazzling = userWarmLevelDTO != null && userWarmLevelDTO.getDazzling() != null && userWarmLevelDTO.getDazzling() != false;
        userDetailInfoDTO.setDazzling(Boolean.valueOf(dazzling));
        UserInformationBO userInformationBO = userCacheInfo.getUserInformationBO();
        if (log.isDebugEnabled()) {
            if (userInformationBO == null) {
                log.debug("\u7528\u6237\u4e2a\u4eba\u8d44\u6599\u4fe1\u606f\u4e3a\u7a7a");
            } else {
                log.debug("\u7528\u6237\u4e2a\u4eba\u8d44\u6599\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)userInformationBO));
            }
        }
        if (userInformationBO != null) {
            userDetailInfoDTO.setPersonalProfile(userInformationBO.getPersonalProfile());
        }
        userDetailInfoDTO.setWearMedalList(userCacheInfo.getWearMedalList());
        userDetailInfoDTO.setUserWarmLevelDTO(userCacheInfo.getUserWarmLevelDTO());
        return userDetailInfoDTO;
    }

    public UserBaseInfoServiceImpl(UserInfoCacheService userInfoCacheService, UserProperties userProperties, UserMedalProperties userMedalProperties, UserInfoService userInfoService, UserStatisticsService userStatisticsService, UserInformationService userInformationService, UserVisitService userVisitService, MessageFacadeIntegrationService messageFacadeIntegrationService, UserInviteService userInviteService, UserMedalService userMedalService, UserWarmLevelService userWarmLevelService, UserEggRoleService userEggRoleService, SixEnjoyDataStatisticsIntegrationService sixEnjoyDataStatisticsIntegrationService, UserAccountService userAccountService, UserEggInviteService userEggInviteService, SixEnjoyInviteFoodsIntegrationService sixEnjoyInviteFoodsIntegrationService) {
        this.userInfoCacheService = userInfoCacheService;
        this.userProperties = userProperties;
        this.userMedalProperties = userMedalProperties;
        this.userInfoService = userInfoService;
        this.userStatisticsService = userStatisticsService;
        this.userInformationService = userInformationService;
        this.userVisitService = userVisitService;
        this.messageFacadeIntegrationService = messageFacadeIntegrationService;
        this.userInviteService = userInviteService;
        this.userMedalService = userMedalService;
        this.userWarmLevelService = userWarmLevelService;
        this.userEggRoleService = userEggRoleService;
        this.sixEnjoyDataStatisticsIntegrationService = sixEnjoyDataStatisticsIntegrationService;
        this.userAccountService = userAccountService;
        this.userEggInviteService = userEggInviteService;
        this.sixEnjoyInviteFoodsIntegrationService = sixEnjoyInviteFoodsIntegrationService;
    }
}

