/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.common.enums.UserTypeEnum;
import com.bxm.egg.user.constant.BaseDistributeKeyConstant;
import com.bxm.egg.user.equitylevelmedal.UserEquityLevelMedalService;
import com.bxm.egg.user.info.UserManageService;
import com.bxm.egg.user.integration.sync.HuolaUserRegisterIntegrationService;
import com.bxm.egg.user.mapper.UserGrantWechatAppMapper;
import com.bxm.egg.user.mapper.UserInfoMapper;
import com.bxm.egg.user.model.dto.info.manage.UserInfoManageDTO;
import com.bxm.egg.user.model.dto.manage.info.UserManageListDTO;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.equitylevelmedal.UserEquityLevelInfoDTO;
import com.bxm.egg.user.model.param.CancelUserParam;
import com.bxm.egg.user.model.param.SetTestUserParam;
import com.bxm.egg.user.model.param.manage.info.UserManageQueryParam;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserManageServiceImpl
implements UserManageService {
    private static final Logger log = LoggerFactory.getLogger(UserManageServiceImpl.class);
    @Resource
    private UserInfoMapper userInfoMapper;
    @Resource
    private UserEquityLevelMedalService userEquityLevelMedalService;
    @Resource
    private UserGrantWechatAppMapper userGrantWechatAppMapper;
    @Resource
    private DistributedLock distributedLock;
    @Resource
    private HuolaUserRegisterIntegrationService huolaUserRegisterIntegrationService;

    @Override
    public IPageModel<UserManageListDTO> getUserList(UserManageQueryParam param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        IPage pageResult = this.userInfoMapper.queryUserInfoList((IPage)page, param);
        if (!CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            ArrayList userIdList = Lists.newArrayList();
            pageResult.getRecords().forEach(item -> userIdList.add(item.getUserId()));
            List<UserEquityLevelInfoDTO> equityLevelInfoList = this.userEquityLevelMedalService.getEquityLevelInfoList(userIdList, false);
            if (!equityLevelInfoList.isEmpty()) {
                Map<Long, List<UserEquityLevelInfoDTO>> equityLevelMap = equityLevelInfoList.stream().collect(Collectors.groupingBy(UserEquityLevelInfoDTO::getUserId));
                pageResult.getRecords().forEach(user -> {
                    List userEquityLevelMedalInfoDTOS = (List)equityLevelMap.get(user.getUserId());
                    if (Objects.nonNull(userEquityLevelMedalInfoDTOS) && !userEquityLevelMedalInfoDTOS.isEmpty()) {
                        log.info("\u7528\u6237id:{}, \u6743\u76ca\u4fe1\u606f\uff1a{}", (Object)user.getUserId(), (Object)JSON.toJSONString((Object)userEquityLevelMedalInfoDTOS));
                        user.setWarmLevel(((UserEquityLevelInfoDTO)userEquityLevelMedalInfoDTOS.get(0)).getUserEquityDTO().getLevel());
                    }
                });
            }
            pageResult.getRecords().forEach(userInfo -> userInfo.setMedalNum(Integer.valueOf(this.userEquityLevelMedalService.getUserMedalNum(userInfo.getUserId()))));
        }
        return PlusPageModelDTO.build((IPage)page);
    }

    @Override
    public Message cancelUser(CancelUserParam cancelUserParam) {
        String cancelUserLockKey = this.buildCancelUserLockKey(cancelUserParam.getUserId());
        if (!this.distributedLock.lock(cancelUserLockKey)) {
            log.error("\u6ce8\u9500\u7528\u6237\u5b58\u5728\u91cd\u590d\u8bf7\u6c42:[{}]", (Object)cancelUserParam);
            this.distributedLock.unlock(cancelUserLockKey);
            return Message.build((boolean)false, (String)"\u6ce8\u9500\u7528\u6237\u592a\u9891\u7e41\u4e86~");
        }
        UserInfoEntity userInfoEntity = (UserInfoEntity)this.userInfoMapper.selectById((Serializable)cancelUserParam.getUserId());
        if (Objects.isNull(userInfoEntity)) {
            this.distributedLock.unlock(cancelUserLockKey);
            return Message.build((boolean)false, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (userInfoEntity.getDeleted() == 1) {
            this.distributedLock.unlock(cancelUserLockKey);
            return Message.build((boolean)false, (String)"\u7528\u6237\u5df2\u6ce8\u9500\u8bf7\u52ff\u91cd\u590d\u6ce8\u9500");
        }
        if (UserTypeEnum.TEST.getCode() != userInfoEntity.getType().intValue()) {
            this.distributedLock.unlock(cancelUserLockKey);
            return Message.build((boolean)false, (String)"\u53ea\u80fd\u6ce8\u9500\u6d4b\u8bd5\u7528\u6237\u54e6~");
        }
        this.cancelUserInfo(cancelUserParam, userInfoEntity);
        this.cancelWechatGrantInfo(cancelUserParam);
        this.distributedLock.unlock(cancelUserLockKey);
        return Message.build((boolean)true);
    }

    @Override
    public List<UserInfoManageDTO> selectUserInfoManageList(Long userId, String nickname) {
        return this.userInfoMapper.selectUserInfoManageList(userId, nickname);
    }

    @Override
    public Message setTestUser(SetTestUserParam setTestUserParam) {
        String setTestUserLockKey = this.buildSetTestUserLockKey(setTestUserParam.getUserId());
        if (!this.distributedLock.lock(setTestUserLockKey)) {
            log.error("\u8bbe\u7f6e\u6d4b\u8bd5\u7528\u6237\u5b58\u5728\u91cd\u590d\u8bf7\u6c42:[{}]", (Object)setTestUserParam);
            this.distributedLock.unlock(setTestUserLockKey);
            return Message.build((boolean)false, (String)"\u8bbe\u7f6e\u6d4b\u8bd5\u7528\u6237\u592a\u9891\u7e41\u4e86~");
        }
        UserInfoEntity userInfoEntity = (UserInfoEntity)this.userInfoMapper.selectById((Serializable)setTestUserParam.getUserId());
        if (Objects.isNull(userInfoEntity)) {
            this.distributedLock.unlock(setTestUserLockKey);
            return Message.build((boolean)false, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(UserTypeEnum.TEST.getCode(), userInfoEntity.getType())) {
            this.distributedLock.unlock(setTestUserLockKey);
            return Message.build((boolean)false, (String)"\u8be5\u7528\u6237\u5df2\u7ecf\u662f\u6d4b\u8bd5\u7528\u6237\u8bf7\u52ff\u91cd\u590d\u8bbe\u7f6e");
        }
        if (Objects.equals(UserTypeEnum.VIRTUAL.getCode(), userInfoEntity.getType())) {
            this.distributedLock.unlock(setTestUserLockKey);
            return Message.build((boolean)false, (String)"\u865a\u62df\u7528\u6237\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u6d4b\u8bd5\u7528\u6237\u54e6~");
        }
        UserInfoEntity updateUserEntity = new UserInfoEntity();
        updateUserEntity.setId(setTestUserParam.getUserId());
        updateUserEntity.setType(Integer.valueOf(UserTypeEnum.TEST.getCode()));
        this.userInfoMapper.updateById((Object)updateUserEntity);
        this.distributedLock.unlock(setTestUserLockKey);
        return Message.build((boolean)true);
    }

    private void cancelWechatGrantInfo(CancelUserParam cancelUserParam) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserGrantWechatAppEntity::getUserId, (Object)cancelUserParam.getUserId());
        List userGrantWechatAppEntityList = this.userGrantWechatAppMapper.selectList((Wrapper)queryWrapper);
        for (UserGrantWechatAppEntity userGrantWechatAppEntity : userGrantWechatAppEntityList) {
            UserGrantWechatAppEntity updateGrantEntity = new UserGrantWechatAppEntity();
            String randomStr = this.getRandomStr();
            updateGrantEntity.setDeleted(Integer.valueOf(1));
            updateGrantEntity.setOpenId(randomStr + "-" + userGrantWechatAppEntity.getOpenId());
            updateGrantEntity.setUnionId(randomStr + "-" + userGrantWechatAppEntity.getUnionId());
            LambdaQueryWrapper updateQueryWrapper = new LambdaQueryWrapper();
            updateQueryWrapper.eq(UserGrantWechatAppEntity::getUserId, (Object)cancelUserParam.getUserId());
            this.userGrantWechatAppMapper.update((Object)updateGrantEntity, (Wrapper)updateQueryWrapper);
        }
    }

    private void cancelUserInfo(CancelUserParam cancelUserParam, UserInfoEntity userInfoEntity) {
        UserInfoEntity updateEntity = new UserInfoEntity();
        String afterPhone = StringUtils.substringAfter((String)userInfoEntity.getPhone(), (String)"1");
        List<String> afterPhoneList = Arrays.asList(afterPhone.split(""));
        Collections.shuffle(afterPhoneList);
        StringBuilder randomPhone = new StringBuilder();
        for (String s : afterPhoneList) {
            randomPhone.append(s);
        }
        String invalidPhone = "2" + StringUtils.substring((String)randomPhone.toString(), (int)0, (int)8) + RandomUtils.getShortCode((int)2);
        updateEntity.setId(cancelUserParam.getUserId());
        updateEntity.setDeleted(Integer.valueOf(1));
        updateEntity.setPhone(invalidPhone);
        updateEntity.setUsername(invalidPhone);
        this.userInfoMapper.updateById((Object)updateEntity);
        this.huolaUserRegisterIntegrationService.delUser(cancelUserParam.getUserId(), invalidPhone);
    }

    private String getRandomStr() {
        return ((DateFormat)DateUtils.DATE_TIME_SECOND_FORMAT_THREAD_LOCAL.get()).format(new Date());
    }

    private String buildCancelUserLockKey(Long userId) {
        return BaseDistributeKeyConstant.CANCEL_USER_LOCK_KEY.copy().appendKey((Object)userId).gen();
    }

    private String buildSetTestUserLockKey(Long userId) {
        return BaseDistributeKeyConstant.SET_TEST_USER_LOCK_KEY.copy().appendKey((Object)userId).gen();
    }
}

