/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.constant.BaseDistributeKeyConstant;
import com.bxm.egg.user.info.UserExtendService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.info.UserWechatGrantService;
import com.bxm.egg.user.info.msg.UserInfoChangeSender;
import com.bxm.egg.user.mapper.UserGrantWechatAppMapper;
import com.bxm.egg.user.model.bo.UserWechatBindBO;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.UserBindWxParam;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserWechatGrantServiceImpl
implements UserWechatGrantService {
    private static final Logger log = LoggerFactory.getLogger(UserWechatGrantServiceImpl.class);
    @Resource
    private UserGrantWechatAppMapper userGrantWechatAppMapper;
    @Resource
    private DistributedLock distributedLock;
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private UserInfoChangeSender userInfoChangeSender;
    @Resource
    private UserExtendService userExtendService;

    @Override
    public Optional<UserGrantWechatAppEntity> userInfoUnionIdExist(String unionId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserGrantWechatAppEntity::getUnionId, (Object)unionId);
        queryWrapper.eq(UserGrantWechatAppEntity::getDeleted, (Object)0);
        UserGrantWechatAppEntity userGrantWechatAppEntity = (UserGrantWechatAppEntity)this.userGrantWechatAppMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.nonNull(userGrantWechatAppEntity)) {
            return Optional.of(userGrantWechatAppEntity);
        }
        return Optional.empty();
    }

    @Override
    public int updateWechatGrantBindUserId(Long userId, String unionId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserGrantWechatAppEntity::getUnionId, (Object)unionId);
        UserGrantWechatAppEntity updateEntity = new UserGrantWechatAppEntity();
        updateEntity.setUserId(userId);
        return this.userGrantWechatAppMapper.update((Object)updateEntity, (Wrapper)queryWrapper);
    }

    @Override
    public Message userBindWx(UserBindWxParam userBindWxParam) {
        String resource = this.buildBindWxUserLockKey(userBindWxParam.getUserId());
        if (!this.distributedLock.lock(resource)) {
            log.info("\u51fa\u73b0\u91cd\u590d\u70b9\u51fb\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)userBindWxParam));
            return null;
        }
        if (this.userHasBindWx(userBindWxParam.getUserId()).booleanValue()) {
            this.distributedLock.unlock(resource);
            return Message.build((boolean)false, (String)"\u8be5\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u8fc7\u5fae\u4fe1\uff0c\u8bf7\u52ff\u91cd\u590d\u7ed1\u5b9a");
        }
        UserWechatBindBO userWechatBindBO = new UserWechatBindBO();
        BeanUtils.copyProperties((Object)userBindWxParam, (Object)userWechatBindBO);
        this.grantBindWxRecord(userWechatBindBO);
        this.updateUserWxBindRelationInfo(userBindWxParam);
        this.userInfoChangeSender.sendUserChangeMsg(userBindWxParam.getUserId());
        this.userExtendService.initComplete(userBindWxParam.getUserId());
        this.distributedLock.unlock(resource);
        return Message.build((boolean)true);
    }

    private void updateUserWxBindRelationInfo(UserBindWxParam userBindWxParam) {
        UserInfoEntity updateUserInfo = new UserInfoEntity();
        String newHeadImg = this.userExtendService.uploadWechatImage(userBindWxParam.getHeadImageUrl(), (BasicParam)userBindWxParam, userBindWxParam.getUserId());
        updateUserInfo.setId(userBindWxParam.getUserId());
        updateUserInfo.setHeadImg(newHeadImg);
        updateUserInfo.setNickname(userBindWxParam.getNickName());
        updateUserInfo.setSex(userBindWxParam.getSex());
        this.userInfoService.updateUserInfo(updateUserInfo);
    }

    @Override
    public Boolean userHasBindWx(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserGrantWechatAppEntity::getUserId, (Object)userId);
        queryWrapper.eq(UserGrantWechatAppEntity::getDeleted, (Object)0);
        List grantWechatAppEntityList = this.userGrantWechatAppMapper.selectList((Wrapper)queryWrapper);
        return !CollectionUtils.isEmpty((Collection)grantWechatAppEntityList);
    }

    @Override
    public Boolean grantBindWxRecord(UserWechatBindBO userWechatBindBO) {
        UserGrantWechatAppEntity entity = new UserGrantWechatAppEntity();
        entity.setId(SequenceHolder.nextLongId());
        entity.setCountry(userWechatBindBO.getCountry());
        entity.setProvince(userWechatBindBO.getProvince());
        entity.setCity(userWechatBindBO.getCity());
        entity.setNickName(userWechatBindBO.getNickName());
        entity.setHeadImg(userWechatBindBO.getHeadImageUrl());
        entity.setOpenId(userWechatBindBO.getOpenId());
        entity.setUnionId(userWechatBindBO.getUnionId());
        entity.setSex(userWechatBindBO.getSex());
        entity.setUserId(userWechatBindBO.getUserId());
        entity.setCreateTime(new Date());
        return this.userGrantWechatAppMapper.insert((Object)entity) > 0;
    }

    private String buildBindWxUserLockKey(Long userId) {
        return BaseDistributeKeyConstant.USER_BIND_WX_LOCK_KEY.copy().appendKey((Object)userId).gen();
    }
}

