/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.location.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.dto.LocationDTO;
import com.bxm.egg.user.event.ActiveActionEvent;
import com.bxm.egg.user.event.UserActionEvent;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.integration.LocationIntegrationService;
import com.bxm.egg.user.location.UserInternalService;
import com.bxm.egg.user.location.event.UserLocationChangeEvent;
import com.bxm.egg.user.login.UserParamCheckService;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.egg.user.model.param.ChangeLocationParam;
import com.bxm.egg.user.model.param.UserLocationParam;
import com.bxm.egg.user.properties.CommonProperties;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.google.common.eventbus.EventBus;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserInternalServiceImpl
implements UserInternalService {
    private static final Logger log = LoggerFactory.getLogger(UserInternalServiceImpl.class);
    private LocationIntegrationService locationIntegrationService;
    private CommonProperties commonProperties;
    private UserParamCheckService userParamCheckService;
    private EventBus userActionEventBus;
    private UserStatisticsService userStatisticsService;

    @Override
    public LocationDTO doPostingLocation(ChangeLocationParam changeLocationParam, String ip) {
        Message message = this.userParamCheckService.checkPostLocationParam(changeLocationParam.getCode(), changeLocationParam.getUserId());
        if (!message.isSuccess()) {
            log.error(message.getLastMessage());
        }
        if (null == changeLocationParam.getCode()) {
            changeLocationParam.setCode(this.commonProperties.getLocationCode());
        }
        LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(changeLocationParam.getCode());
        if (null != changeLocationParam.getUserId()) {
            UserStatisticsEntity userStatisticsEntity = this.userStatisticsService.selectUserStatisticsByUserId(changeLocationParam.getUserId());
            locationDTO.setPublishPostNum(Integer.valueOf(userStatisticsEntity == null ? 0 : userStatisticsEntity.getPostNum()));
            SpringContextHolder.getApplicationContext().publishEvent((Object)UserLocationChangeEvent.builder().areaCode(locationDTO.getCode()).areaName(locationDTO.getName()).userId(changeLocationParam.getUserId()).build());
        } else {
            locationDTO.setPublishPostNum(Integer.valueOf(0));
        }
        return locationDTO;
    }

    @Override
    public Boolean postUserPositionAndLoginInfo(UserLocationParam userLocationParam) {
        if (log.isDebugEnabled()) {
            log.debug("\u4e0a\u62a5\u7528\u6237\u5b9a\u4f4d\u4ee5\u53ca\u6d3b\u8dc3\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)userLocationParam));
        }
        LocationDTO locationByGeocode = this.locationIntegrationService.getLocationByGeocode(userLocationParam.getCurrentAreaCode());
        UserActionEvent userActionEvent = ActiveActionEvent.of().setLastLoginTime(new Date()).setLongitude(userLocationParam.getLongitude()).setLatitude(userLocationParam.getLatitude()).setCurrentAreaCode(locationByGeocode.getCode()).setUserId(userLocationParam.getUserId());
        this.userActionEventBus.post((Object)userActionEvent);
        return true;
    }

    @Autowired
    public UserInternalServiceImpl(LocationIntegrationService locationIntegrationService, CommonProperties commonProperties, UserParamCheckService userParamCheckService, EventBus userActionEventBus, UserStatisticsService userStatisticsService) {
        this.locationIntegrationService = locationIntegrationService;
        this.commonProperties = commonProperties;
        this.userParamCheckService = userParamCheckService;
        this.userActionEventBus = userActionEventBus;
        this.userStatisticsService = userStatisticsService;
    }
}

