/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.location.listener;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.event.LocationActionEvent;
import com.bxm.egg.user.event.UserActionEvent;
import com.bxm.egg.user.integration.UserSyncIntegrationService;
import com.bxm.egg.user.location.UserLocationService;
import com.bxm.egg.user.location.event.UserLocationChangeEvent;
import com.bxm.egg.user.mapper.UserLocationHistoryMapper;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import com.bxm.egg.user.model.vo.UserLocationHistory;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.google.common.eventbus.EventBus;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class UserLocationChangeListener {
    private static final Logger log = LoggerFactory.getLogger(UserLocationChangeListener.class);
    private UserLocationHistoryMapper userLocationHistoryMapper;
    private UserLocationService userLocationService;
    private EventBus userActionEventBus;
    private UserSyncIntegrationService userSyncIntegrationService;

    @EventListener
    @Async
    public void userInfoChangeEvent(UserLocationChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("\u76d1\u542c\u5230\u7528\u6237\u4f4d\u7f6e\u6539\u53d8\u4e8b\u4ef6\uff0c\u4e8b\u4ef6\u5185\u5bb9: {}", (Object)JSON.toJSONString((Object)event));
        }
        Long userId = event.getUserId();
        String areaCode = event.getAreaCode();
        String areaName = event.getAreaName();
        UserLocationEntity userLocationInfo = this.userLocationService.getUserLocationByUserId(userId);
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)event.getAreaCode()) && com.bxm.newidea.component.tools.StringUtils.notEquals((CharSequence)userLocationInfo.getLocationCode(), (CharSequence)areaCode)) {
            String oldLocationCode = userLocationInfo.getLocationCode();
            userLocationInfo.setLocationCode(areaCode);
            userLocationInfo.setLocationName(areaName);
            this.userLocationService.updateUserLocationInfo(userId, areaCode, areaName);
            UserLocationHistory userLocationHistory = new UserLocationHistory();
            userLocationHistory.setAddTime(new Date());
            userLocationHistory.setId(SequenceHolder.nextLongId());
            userLocationHistory.setLocationCode(areaCode);
            userLocationHistory.setUserId(userId);
            this.userLocationHistoryMapper.insert(userLocationHistory);
            this.userSyncIntegrationService.changeLocation(userId, areaCode);
            if (StringUtils.isNotBlank((CharSequence)areaCode)) {
                UserActionEvent userActionEvent = LocationActionEvent.of().setLocationCode(areaCode).setLocationName(areaName).setOldLocationCode(oldLocationCode).setUserId(userId);
                this.userActionEventBus.post((Object)userActionEvent);
            }
        } else {
            log.warn("\u7528\u6237\u4f4d\u7f6e\u4fe1\u606f\u53d8\u66f4\u5931\u8d25,\uff0c\u7528\u6237ID\uff1a{},\u53d8\u66f4\u540e\u7684\u4f4d\u7f6e:{},\u7528\u6237\u7684\u5f53\u524d\u4f4d\u7f6e\uff1a{}", new Object[]{userId, areaCode, userLocationInfo.getLocationCode()});
        }
    }

    public UserLocationChangeListener(UserLocationHistoryMapper userLocationHistoryMapper, UserLocationService userLocationService, EventBus userActionEventBus, UserSyncIntegrationService userSyncIntegrationService) {
        this.userLocationHistoryMapper = userLocationHistoryMapper;
        this.userLocationService = userLocationService;
        this.userActionEventBus = userActionEventBus;
        this.userSyncIntegrationService = userSyncIntegrationService;
    }
}

