/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.strategy.support;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.login.strategy.AbstractUserLoginStrategy;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.login.UserAccountAppLoginParam;
import com.bxm.newidea.component.bo.Message;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AccountLoginStrategy
extends AbstractUserLoginStrategy<UserAccountAppLoginParam> {
    private static final Logger log = LoggerFactory.getLogger(AccountLoginStrategy.class);
    @Resource
    private UserInfoService userInfoService;

    @Override
    protected Long checkExists(UserAccountAppLoginParam loginParam) {
        Optional<Long> userIdOptional = this.userInfoService.userUsernameExist(loginParam.getUserName());
        if (!userIdOptional.isPresent()) {
            log.error("\u767b\u5f55\u7684\u7528\u6237\u540d\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7\u4e86\u524d\u9762\u7684\u767b\u5f55\u6821\u9a8c\uff0c\u9700\u6392\u67e5\u539f\u56e0\uff0c\u767b\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)loginParam));
            return null;
        }
        return userIdOptional.get();
    }

    @Override
    protected Message beforeLoginAuthentication(UserAccountAppLoginParam loginParam) {
        Optional<Long> userIdOptional = this.userInfoService.userPhoneExist(loginParam.getUserName());
        if (!userIdOptional.isPresent()) {
            log.warn("\u7528\u6237\u767b\u5f55\uff0c\u8f93\u5165\u7684\u7528\u6237\u540d\u4e0d\u5b58\u5728\uff0c\u767b\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)loginParam));
            return Message.build((boolean)false, (String)"\u60a8\u767b\u5f55\u7684\u7528\u6237\u540d\u4e0d\u5b58\u5728");
        }
        if (!this.userInfoService.hasSettingPassword(loginParam.getUserName())) {
            Message errorMsg = Message.build((boolean)false, (String)"\u60a8\u7684\u8d26\u6237\u672a\u8bbe\u7f6e\u5bc6\u7801");
            errorMsg.setBizCode("100106");
            return errorMsg;
        }
        if (!this.userInfoService.checkUserPassword(userIdOptional.get(), loginParam.getUserName(), loginParam.getPassword())) {
            return Message.build((boolean)false, (String)"\u60a8\u8f93\u5165\u7684\u5bc6\u7801\u9519\u8bef");
        }
        return Message.build((boolean)true);
    }

    @Override
    public UserLoginTypeEnum type() {
        return UserLoginTypeEnum.ACCOUNT;
    }

    @Override
    protected boolean saveIdentity(UserAccountAppLoginParam loginParam, Long userId) {
        return true;
    }

    @Override
    protected void fillUserInfo(UserAccountAppLoginParam loginParam, UserInfoEntity newUser) {
    }

    @Override
    protected Message handleNewUser(UserAccountAppLoginParam loginParam) {
        log.error("\u767b\u5f55\u7684\u7528\u6237\u540d\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7\u4e86\u524d\u9762\u7684\u767b\u5f55\u6821\u9a8c\uff0c\u9700\u6392\u67e5\u539f\u56e0\uff0c\u767b\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)loginParam));
        return Message.build((boolean)false, (String)"\u60a8\u767b\u5f55\u7684\u7528\u6237\u540d\u4e0d\u5b58\u5728");
    }
}

