/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.login.strategy.support;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.info.UserWechatGrantService;
import com.bxm.egg.user.login.strategy.AbstractUserLoginStrategy;
import com.bxm.egg.user.mapper.UserGrantWechatAppMapper;
import com.bxm.egg.user.model.bo.UserWechatBindBO;
import com.bxm.egg.user.model.dto.login.LoginResultDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.login.WechatAppLoginParam;
import com.bxm.newidea.component.bo.Message;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class WechatLoginStrategy
extends AbstractUserLoginStrategy<WechatAppLoginParam> {
    private static final Logger log = LoggerFactory.getLogger(WechatLoginStrategy.class);
    @Resource
    private UserGrantWechatAppMapper userGrantWechatAppMapper;
    @Resource
    private UserWechatGrantService userWechatGrantService;

    @Override
    protected Long checkExists(WechatAppLoginParam loginParam) {
        Optional<Long> userUnionIdExistOptional = this.userInfoService.userUnionIdExist(loginParam.getUnionId());
        return userUnionIdExistOptional.orElse(null);
    }

    @Override
    protected Message afterLoginAuthentication(WechatAppLoginParam loginParam, LoginResultDTO resultDTO) {
        if (resultDTO.getUserId() == -1L) {
            return this.buildNoBindPhoneResultMsg(resultDTO);
        }
        UserInfoEntity userInfoEntity = this.userInfoService.selectUserById(resultDTO.getUserId());
        if (Objects.isNull(userInfoEntity) || StringUtils.isEmpty((Object)userInfoEntity.getPhone())) {
            this.buildNoBindPhoneResultMsg(resultDTO);
        }
        return Message.build((boolean)true);
    }

    private Message buildNoBindPhoneResultMsg(LoginResultDTO resultDTO) {
        log.warn("\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u5fae\u4fe1\uff0c\u672a\u7ed1\u5b9a\u624b\u673a\uff0c\u7ed1\u5b9a\u624b\u673a\u540e\u624d\u80fd\u7ee7\u7eed\u767b\u5f55,\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)resultDTO));
        Message resultMessage = Message.build((boolean)false, (String)"\u60a8\u9700\u8981\u7ed1\u5b9a\u624b\u673a\u53f7");
        resultMessage.setBizCode("100105");
        return resultMessage;
    }

    @Override
    public UserLoginTypeEnum type() {
        return UserLoginTypeEnum.WX;
    }

    @Override
    protected boolean saveIdentity(WechatAppLoginParam loginParam, Long userId) {
        UserWechatBindBO userWechatBindBO = new UserWechatBindBO();
        BeanUtils.copyProperties((Object)loginParam, (Object)userWechatBindBO);
        userWechatBindBO.setUserId(userId);
        return this.userWechatGrantService.grantBindWxRecord(userWechatBindBO);
    }

    @Override
    protected void fillUserInfo(WechatAppLoginParam loginParam, UserInfoEntity newUser) {
    }

    @Override
    protected Message handleNewUser(WechatAppLoginParam loginParam) {
        if (!this.userWechatGrantService.userInfoUnionIdExist(loginParam.getUnionId()).isPresent()) {
            this.saveIdentity(loginParam, (Long)null);
        }
        Message msg = Message.build((boolean)true);
        LoginResultDTO resultDTO = new LoginResultDTO();
        resultDTO.setUserId(Long.valueOf(-1L));
        return msg.addParam("loginResultDTO", (Object)resultDTO);
    }
}

