/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.medal.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.enums.UserMedalCounterTypeEnum;
import com.bxm.egg.user.enums.UserMedalTypeEnum;
import com.bxm.egg.user.facade.enums.WarmRuleEnum;
import com.bxm.egg.user.facade.param.UserWarmActionParam;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.medal.strategy.AbstractMedalCounterStrategy;
import com.bxm.egg.user.model.dto.medal.MedalExtDataDTO;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.egg.user.model.entity.medal.UserMedalInfoEntity;
import com.bxm.egg.user.warmlevel.impl.WarmHandlerProxy;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SignCounterStrategy
extends AbstractMedalCounterStrategy {
    private static final Logger log = LoggerFactory.getLogger(SignCounterStrategy.class);
    @Resource
    private UserStatisticsService userStatisticsService;
    @Resource
    private WarmHandlerProxy warmHandlerProxy;

    @Override
    public void handleCounterData(UserMedalCounterDTO userMedalCounterDTO) {
        List<UserMedalInfoEntity> medalInfoEntityList = this.achievementMedalCacheManager.getMedalListByType(UserMedalTypeEnum.SIGN_MEDAL.name());
        UserStatisticsEntity userStatisticsEntity = this.userStatisticsService.selectUserStatisticsByUserId(userMedalCounterDTO.getUserId());
        if (userStatisticsEntity == null) {
            log.error("\u7528\u6237\u7edf\u8ba1\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u5904\u7406\u7b7e\u5230\u52cb\u7ae0\u6570\u636e\uff1a{}", (Object)userMedalCounterDTO.getUserId());
            return;
        }
        UserWarmActionParam userWarmActionParam = UserWarmActionParam.builder().userId(userMedalCounterDTO.getUserId()).warmRuleEnum(WarmRuleEnum.SIGN).build();
        this.warmHandlerProxy.handle(userWarmActionParam);
        for (UserMedalInfoEntity userMedalInfoEntity : medalInfoEntityList) {
            MedalExtDataDTO medalExtDataDTO = (MedalExtDataDTO)JSON.parseObject((String)userMedalInfoEntity.getRuleExtData(), MedalExtDataDTO.class);
            if (userStatisticsEntity.getMaxSignNum() >= medalExtDataDTO.getTargetValue()) {
                this.grantAchievementMedal(userMedalCounterDTO.getUserId(), userMedalInfoEntity);
                continue;
            }
            return;
        }
    }

    @Override
    public String counterType() {
        return UserMedalCounterTypeEnum.SIGN_NUM.name();
    }

    public SignCounterStrategy(UserStatisticsService userStatisticsService, WarmHandlerProxy warmHandlerProxy) {
        this.userStatisticsService = userStatisticsService;
        this.warmHandlerProxy = warmHandlerProxy;
    }
}

