/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.onekey.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.egg.user.onekey.JiGuangFlashService;
import com.bxm.egg.user.properties.CommonProperties;
import com.bxm.newidea.component.tools.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JiGuangFlashServiceImpl
implements JiGuangFlashService {
    private static final Logger log = LoggerFactory.getLogger(JiGuangFlashServiceImpl.class);
    private static final String SUCCESS_CODE = "8000";
    private static final String FLASH_LOGIN_URL = "https://api.verification.jpush.cn/v1/web/loginTokenVerify";
    @Resource
    private CommonProperties commonProperties;

    @Override
    public String getPhone(String loginToken) {
        log.info("\u8bf7\u6c42\u95ea\u9a8c\u53c2\u6570\uff1a[{}]", (Object)loginToken);
        if (StringUtils.isNotBlank((CharSequence)this.commonProperties.getJiGuangMockPhone())) {
            String phone = this.commonProperties.getJiGuangMockPhone();
            log.debug("\u7814\u53d1\u73af\u5883\uff0c\u8fd4\u56de\u6a21\u62df\u7684\u6781\u5149\u95ea\u9a8c\u624b\u673a\u53f7\u7801:{}", (Object)phone);
            return phone;
        }
        JSONObject result = this.tokenExchangeMobileRequest(loginToken);
        log.info("\u95ea\u9a8c\u7684\u8fd4\u56de\u7ed3\u679c\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)result));
        if (null == result) {
            log.warn("\u65e0\u6cd5\u89e3\u6790\u95ea\u9a8c\u7684\u8fd4\u56de\u7ed3\u679c\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)loginToken);
            return null;
        }
        String code = result.getString("code");
        if (SUCCESS_CODE.equals(code)) {
            String mobile;
            String secretPhone = result.getString("phone");
            try {
                mobile = this.decrypt(secretPhone, this.commonProperties.getOneKeySecretKey());
                log.info("\u8bf7\u6c42\u5b8c\u6210\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a[{}],\u624b\u673a\u53f7\u7801\uff1a[{}],\u8fd4\u56de\u503c\uff1a[{}]", new Object[]{loginToken, mobile, result});
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u95ea\u9a8c\u8fd4\u56de\u503c\u9519\u8bef\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a[{}]\uff0c\u8fd4\u56de\u503c\uff1a[{}]", (Object)loginToken, (Object)result);
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
            return mobile;
        }
        log.error("\u6781\u5149\u95ea\u9a8c\u8fd4\u56de\u72b6\u6001\u9519\u8bef\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a[{}]\uff0c\u8fd4\u56de\u503c\uff1a[{}]", (Object)loginToken, (Object)result);
        return null;
    }

    private JSONObject tokenExchangeMobileRequest(String loginToken) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("loginToken", loginToken);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", this.getAuthorizationContent());
            String jsonBody = OkHttpUtils.postJsonBody((String)FLASH_LOGIN_URL, (String)JSON.toJSONString(params), headers);
            if (StringUtils.isNotBlank((CharSequence)jsonBody)) {
                return JSONObject.parseObject((String)jsonBody);
            }
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u7aef\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)loginToken);
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String getAuthorizationContent() throws UnsupportedEncodingException {
        String separator = ":";
        String baseStr = "Basic ";
        String appKey = this.commonProperties.getJiGuangAppKey();
        String masterSecret = this.commonProperties.getJiGuangMasterSecret();
        return baseStr + Base64.getEncoder().encodeToString((appKey + separator + masterSecret).getBytes("utf-8"));
    }

    private String decrypt(String secretContent, String prikey) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getMimeDecoder().decode(prikey));
        PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        byte[] b = Base64.getDecoder().decode(secretContent);
        return new String(cipher.doFinal(b));
    }
}

