/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.token.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.jwt.bo.JwtTokenBO;
import com.bxm.component.jwt.builder.TokenBuildParam;
import com.bxm.component.jwt.util.JwtUtil;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.enums.RenewTokenSceneEnum;
import com.bxm.egg.user.facade.bo.UserTokenBO;
import com.bxm.egg.user.model.dto.token.TokenInfoDTO;
import com.bxm.egg.user.model.param.token.RenewTokenParam;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.egg.user.token.TokenService;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.utils.SystemClock;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TokenServiceImpl
implements TokenService {
    private static final Logger log = LoggerFactory.getLogger(TokenServiceImpl.class);
    private RedisStringAdapter redisStringAdapter;
    private UserProperties userProperties;

    @Override
    public TokenInfoDTO renew(RenewTokenParam param) {
        Preconditions.checkNotNull((Object)param.getUserId());
        Preconditions.checkNotNull((Object)param.getRefreshToken());
        String requestRefreshToken = param.getRefreshToken();
        String cacheRefreshToken = this.getCacheRefreshToken(param.getUserId());
        if (log.isDebugEnabled()) {
            log.debug("\u91cd\u65b0\u8bf7\u6c42accessToken\uff0c\u53c2\u6570\uff1a{}, \u573a\u666f\uff1a{}", (Object)JSON.toJSONString((Object)param), (Object)param.getScene());
        }
        if (null == cacheRefreshToken) {
            log.info("[{}] \u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684RefreshToken, \u573a\u666f\uff1a{}", (Object)param.getUserId(), (Object)param.getScene());
            return null;
        }
        if (!requestRefreshToken.equals(cacheRefreshToken)) {
            log.warn("\u8bf7\u6c42\u63d0\u4f9b\u7684RefreshToken\u4e0e\u7f13\u5b58\u4e0d\u4e00\u81f4\uff0cuid\uff1a{},except\uff1a{},actual\uff1a{},\u573a\u666f\uff1a{}", new Object[]{param.getUserId(), cacheRefreshToken, param.getRefreshToken(), param.getScene()});
            return null;
        }
        String secretKey = this.userProperties.getAppTokenSecret();
        JwtTokenBO jwtTokenBO = JwtUtil.parseToken((String)requestRefreshToken, (String)secretKey);
        if (jwtTokenBO.getExpirationDate().getTime() < SystemClock.now()) {
            log.warn("[{}]refreshToken\u5df2\u8fc7\u671f", (Object)param.getUserId());
            return null;
        }
        return this.create(param.getUserId(), (BasicParam)param, param.getScene());
    }

    private String getCacheRefreshToken(Long userId) {
        KeyGenerator key = RedisConfig.USER_REFRESH_TOKEN_CACHE_KEY.copy().appendKey((Object)userId);
        return (String)this.redisStringAdapter.get(key, String.class);
    }

    @Override
    public TokenInfoDTO create(Long userId, BasicParam param, String scene) {
        String secretKey = this.userProperties.getAppTokenSecret();
        TokenInfoDTO tokenInfoDTO = TokenInfoDTO.builder().refreshToken(this.createRefreshToken(userId, secretKey)).accessToken(this.doCreateAccessToken(userId, secretKey)).build();
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u7528\u6237Token\u4fe1\u606f\uff1a{}, \u573a\u666f:{}\uff0c\u7528\u6237id:{}", new Object[]{tokenInfoDTO, scene, userId});
        }
        return tokenInfoDTO;
    }

    private String doCreateAccessToken(Long userId, String key) {
        Date accessTokenExpiredDate = DateUtils.addField((Date)new Date(), (int)13, (int)this.userProperties.getAccessTokenExpiredSeconds());
        return JwtUtil.generateToken((TokenBuildParam)TokenBuildParam.create().putClaim("userId", userId.toString()).setIssueDate(new Date()).setExpirationTime(accessTokenExpiredDate).setSignatureKey(key));
    }

    @Override
    public UserTokenBO renewToken(Long userId) {
        RenewTokenParam param = new RenewTokenParam();
        String cacheRefreshToken = this.getCacheRefreshToken(userId);
        param.setUserId(userId);
        param.setRefreshToken(cacheRefreshToken);
        param.setScene(RenewTokenSceneEnum.GATEWAY_RENEW_TOKEN.name());
        TokenInfoDTO tokenInfoDTO = this.renew(param);
        if (tokenInfoDTO == null) {
            return null;
        }
        UserTokenBO userTokenBO = new UserTokenBO();
        userTokenBO.setReNewAccessToken(tokenInfoDTO.getAccessToken());
        userTokenBO.setReNewRefreshToken(tokenInfoDTO.getRefreshToken());
        return userTokenBO;
    }

    private String createRefreshToken(Long userId, String key) {
        Date refreshTokenExpiredDate = DateUtils.addField((Date)new Date(), (int)13, (int)this.userProperties.getRefreshTokenExpiredSeconds());
        String refreshToken = JwtUtil.generateToken((TokenBuildParam)TokenBuildParam.create().putClaim("userId", userId.toString()).setIssueDate(new Date()).setExpirationTime(refreshTokenExpiredDate).setSignatureKey(key));
        KeyGenerator cacheKey = RedisConfig.USER_REFRESH_TOKEN_CACHE_KEY.copy().appendKey((Object)userId);
        this.redisStringAdapter.set(cacheKey, (Object)refreshToken, (long)this.userProperties.getRefreshTokenExpiredSeconds());
        return refreshToken;
    }

    public TokenServiceImpl(RedisStringAdapter redisStringAdapter, UserProperties userProperties) {
        this.redisStringAdapter = redisStringAdapter;
        this.userProperties = userProperties;
    }
}

