package com.bxm.egg.user.attribute.impl;

import com.bxm.egg.user.attribute.UserAttributeService;
import com.bxm.egg.user.facade.enums.OperateTypeEnum;
import com.bxm.egg.user.facade.enums.UserStatisticsTypeEnum;
import com.bxm.egg.user.facade.param.UserStatisticsOperateParam;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.mapper.UserMapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service
@Slf4j
@AllArgsConstructor
public class UserAttributeServiceImpl implements UserAttributeService {

    private final UserMapper userMapper;

    private final UserStatisticsService userStatisticsService;

    @Override
    public void addUserFollowCount(Long userId, Long targetUserId, boolean isAdd) {

        //操作用户关注数
        userStatisticsService.operateUserStatistics(UserStatisticsOperateParam.builder()
                .operateNum(1)
                .operateTypeEnum(isAdd ? OperateTypeEnum.INCREASE : OperateTypeEnum.REDUCE)
                .userId(userId)
                .userStatisticsType(UserStatisticsTypeEnum.ATTENTION_NUM)
                .build());
        //操作用户粉丝数
        userStatisticsService.operateUserStatistics(UserStatisticsOperateParam.builder()
                .operateNum(1)
                .operateTypeEnum(isAdd ? OperateTypeEnum.INCREASE : OperateTypeEnum.REDUCE)
                .userId(targetUserId)
                .userStatisticsType(UserStatisticsTypeEnum.FAN_NUM)
                .build());
    }


    @Override
    public void addInviteNum(Long userId) {
        userMapper.incrementInviteNum(userId);
    }
}
