/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.egg.user.invite.bind;

import com.bxm.egg.common.constant.InviteTypeEnum;
import com.bxm.egg.user.enums.AppConst;
import com.bxm.egg.user.enums.InviteBindMethodEnum;
import com.bxm.egg.user.enums.InviteRecordStatusEnum;
import com.bxm.egg.user.invite.InviteRecordService;
import com.bxm.egg.user.mapper.InviteRecordMapper;
import com.bxm.egg.user.mapper.UserInviteHistoryMapper;
import com.bxm.egg.user.model.dto.UserInviteBindDTO;
import com.bxm.egg.user.model.param.InviteRecordParam;
import com.bxm.egg.user.model.vo.InviteRecord;
import com.bxm.newidea.component.bo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author : jieli.xu
 * @date 2020/7/13 17:52
 * 开通VIP时绑定邀请关系
 */
@Component
@Slf4j
public class WelfareVipBindMethod extends AbstractBindInviteStrategy {
    @Autowired
    private InviteRecordService inviteRecordService;

    @Autowired
    private InviteRecordMapper inviteRecordMapper;

    @Autowired
    private UserInviteHistoryMapper userInviteHistoryMapper;

    @Override
    protected Message preInvoke(UserInviteBindDTO userInviteBindDTO) {
        //支付：如果是回调，则插入history
        //不是回调  ： 则插入record
        if (userInviteBindDTO.getIsCallback()) {
            InviteRecordParam inviteRecordParam = new InviteRecordParam();
            inviteRecordParam.setUserId(userInviteBindDTO.getInviteUserId());
            inviteRecordParam.setInvitedUserId(userInviteBindDTO.getUserId());
            inviteRecordParam.setStatus(InviteRecordStatusEnum.VALID.getStatus());
            List<InviteRecord> inviteRecordList = inviteRecordMapper.queryUserInviteRecord(inviteRecordParam);
            if (!CollectionUtils.isEmpty(inviteRecordList)) {
                userInviteBindDTO.getUserInviteHistoryBean().setState(AppConst.USER_STATE.NORMAL);
                userInviteBindDTO.getUserInviteHistoryBean().setType(userInviteBindDTO.getUser().getRegisterChannel());
                userInviteBindDTO.getUserInviteHistoryBean().setRelationId(userInviteBindDTO.getUser().getRelationId());
                userInviteBindDTO.getUserInviteHistoryBean().setInviteUserId(userInviteBindDTO.getInviteUserId());
                userInviteBindDTO.getUserInviteHistoryBean().setUserId(userInviteBindDTO.getUserId());
                userInviteBindDTO.getUserInviteHistoryBean().setActiveVip(AppConst.ENABLE.byteValue());
                userInviteBindDTO.getUserInviteHistoryBean().setRelationTitle(InviteTypeEnum.WELFARE_VIP.getDesc());
                return Message.build(true);
            }
        } else {
            //插入record记录，不做其余操作
            inviteRecordService.addInviteRecord(userInviteBindDTO.getInviteUserId(), userInviteBindDTO.getUserId(), this.getBindMethod().name());
        }
        return Message.build(false);
    }

    @Override
    protected Message afterInviteNormal(UserInviteBindDTO userInviteBindDTO) {

        return super.afterInviteNormal(userInviteBindDTO);
    }

    @Override
    protected void beNormalInviteAfter(UserInviteBindDTO userInviteBindDTO) {
    }

    @Override
    protected InviteBindMethodEnum getBindMethod() {
        return InviteBindMethodEnum.WELFARE_VIP;
    }
}
