package com.bxm.egg.user.location;

import com.bxm.egg.user.dto.LocationDTO;
import com.bxm.egg.user.model.param.ChangeLocationParam;
import com.bxm.egg.user.model.param.UserLocationParam;

/**
 * 用户相关内部接口，不对外服务暴露
 *
 * @author wzy
 * @date 2021年09月26日15:16:27
 */
public interface UserInternalService {


    /**
     * 用户进行定位，并存在历史定位表中，需要事务
     *
     * @param ip ip
     * @return 定位信息
     */
    LocationDTO doPostingLocation(ChangeLocationParam changeLocationParam,
                                  String ip);

    /**
     * 上报用户位置信息与用户登录信息-用户的经纬度以及用户登录app的活跃信息
     *
     * @param userLocationParam 用户位置信息参数
     * @return 是否成功
     */
    Boolean postUserPositionAndLoginInfo(UserLocationParam userLocationParam);

}
