package com.bxm.egg.user.location.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.location.UserLocationService;
import com.bxm.egg.user.mapper.UserLocationMapper;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import com.bxm.egg.user.model.param.UserHomeTownParam;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/17 11:12 上午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserLocationServiceImpl implements UserLocationService {

    private final UserLocationMapper userLocationMapper;

    @Override
    public UserLocationEntity getUserLocationByUserId(Long userId) {
        //查询资料信息
        LambdaQueryWrapper<UserLocationEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(UserLocationEntity::getUserId, userId);

        UserLocationEntity userLocationEntity = userLocationMapper.selectOne(queryWrapper);

        if (userLocationEntity == null) {
            return buildValidUserLocation(userId);
        }

        return userLocationEntity;
    }

    private UserLocationEntity buildValidUserLocation(Long userId) {
        UserLocationEntity userLocationEntity = new UserLocationEntity();
        userLocationEntity.setId(0L);
        userLocationEntity.setUserId(userId);

        userLocationEntity.setCreateTime(LocalDateTime.now());
        userLocationEntity.setModifyTime(LocalDateTime.now());

        return userLocationEntity;
    }


    @Override
    public int updateUserHometownInfo(UserHomeTownParam userHomeTownParam) {
        UserLocationEntity userLocationEntity = new UserLocationEntity();

        userLocationEntity.setHometownCode(userHomeTownParam.getHometownCode());
        userLocationEntity.setHometownName(userHomeTownParam.getHometownName());

        LambdaQueryWrapper<UserLocationEntity> updateQueryWrapper = new LambdaQueryWrapper<>();

        updateQueryWrapper.eq(UserLocationEntity::getUserId, userHomeTownParam.getUserId());

        return userLocationMapper.update(userLocationEntity, updateQueryWrapper);
    }

    @Override
    public int updateUserLocationInfo(Long userId,
                                      String locationCode,
                                      String locationName) {
        UserLocationEntity userLocationEntity = new UserLocationEntity();

        userLocationEntity.setLocationCode(locationCode);
        userLocationEntity.setLocationName(locationName);
        userLocationEntity.setUserId(userId);

        LambdaQueryWrapper<UserLocationEntity> updateQueryWrapper = new LambdaQueryWrapper<>();

        updateQueryWrapper.eq(UserLocationEntity::getUserId, userId);

        return userLocationMapper.update(userLocationEntity, updateQueryWrapper);
    }
}